/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import javax.swing.JTable;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.SQLScriptServices;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopySqlPartCommandBase;
import net.sourceforge.squirrel_sql.fw.gui.action.TableNameProvider;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public class TableCopyInsertStatementCommand
extends TableCopySqlPartCommandBase
implements ICommand {
    private final JTable _table;
    private final DataModelImplementationDetails _dataModelImplementationDetails;

    public TableCopyInsertStatementCommand(JTable table, DataModelImplementationDetails dataModelImplementationDetails) {
        super(dataModelImplementationDetails.getSession());
        this._dataModelImplementationDetails = dataModelImplementationDetails;
        if (table == null) {
            throw new IllegalArgumentException("JTable == null");
        }
        this._table = table;
    }

    @Override
    public void execute() {
        int nbrSelRows = this._table.getSelectedRowCount();
        int nbrSelCols = this._table.getSelectedColumnCount();
        int[] selRows = this._table.getSelectedRows();
        int[] selCols = this._table.getSelectedColumns();
        if (selRows.length == 0 || selCols.length == 0) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        StringBuffer colNames = new StringBuffer();
        StringBuffer vals = new StringBuffer();
        TableNameProvider tableNameProvider = new TableNameProvider(this._dataModelImplementationDetails);
        for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
            boolean firstCol = true;
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                TableColumn col = this._table.getColumnModel().getColumn(selCols[colIdx]);
                if (!(col instanceof ExtTableColumn)) continue;
                ColumnDisplayDefinition colDef = ((ExtTableColumn)col).getColumnDisplayDefinition();
                tableNameProvider.addColDef(colDef);
                if (firstCol) {
                    firstCol = false;
                    vals.append("(");
                } else {
                    colNames.append(",");
                    vals.append(",");
                }
                Object cellObj = this._table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                String columnName = colDef.getColumnName();
                colNames.append(SQLScriptServices.formatColumnName(columnName));
                vals.append(this.getData(colDef, cellObj, TableCopySqlPartCommandBase.StatType.IN));
            }
            tableNameProvider.colDefsFinished();
            colNames.append(")");
            vals.append(")");
            buf.append("INSERT INTO " + tableNameProvider.getTableName() + " (").append(colNames).append(" VALUES ").append(vals);
            if (1 < this._dataModelImplementationDetails.getStatementSeparator().length()) {
                buf.append(" ").append(this._dataModelImplementationDetails.getStatementSeparator()).append("\n");
            } else {
                buf.append(this._dataModelImplementationDetails.getStatementSeparator()).append("\n");
            }
            colNames.setLength(0);
            vals.setLength(0);
        }
        ClipboardUtil.copyToClip(buf);
    }
}

