/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.colorrows;

import java.awt.Color;
import java.awt.MouseInfo;
import java.awt.Point;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.colorrows.ColorSelectionType;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ColorSelectionCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ColorSelectionCommand.class);
    private static final String PREF_KEY_PREVIOUS_COLOR_RGB = "ColorSelectedRowsCommand.previous.color.rgb";
    private DataSetViewerTable _table;
    private ColorSelectionType _selectionType;

    public ColorSelectionCommand(DataSetViewerTable table, ColorSelectionType selectionType) {
        this._table = table;
        this._selectionType = selectionType;
    }

    public void execute() {
        Color startColor = this._table.getColoringService().getUserColorHandler().getFirstColorInSelection();
        if (null != startColor) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(this.createChooseColorItem(startColor));
            popupMenu.add(this.createRemoveColorItem());
            Point p = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(p, this._table);
            popupMenu.show(this._table, p.x, p.y);
        } else {
            this.colorSelection(null, false);
        }
    }

    private JMenuItem createRemoveColorItem() {
        JMenuItem ret = new JMenuItem(s_stringMgr.getString("ColorSelectedRowsCommand.remove.color"));
        ret.addActionListener(e -> this.colorSelection(null, true));
        return ret;
    }

    private JMenuItem createChooseColorItem(Color startColor) {
        JMenuItem ret = new JMenuItem(s_stringMgr.getString("ColorSelectedRowsCommand.choose.color"));
        ret.addActionListener(e -> this.colorSelection(startColor, false));
        return ret;
    }

    private void colorSelection(Color startColor, boolean remove) {
        Color newColor = null;
        if (!remove) {
            int rgb;
            if (null == startColor && (rgb = ColorSelectionCommand.getPreviousColorRgb()) != -1) {
                startColor = new Color(rgb);
            }
            if (null == (newColor = JColorChooser.showDialog(GUIUtils.getOwningFrame(this._table), s_stringMgr.getString("ColorSelectedRowsCommand.color.selected.rows"), startColor))) {
                return;
            }
            ColorSelectionCommand.setPreviousRowColorRgb(newColor);
        }
        this._table.getColoringService().getUserColorHandler().setColorForSelection(newColor, this._selectionType);
    }

    public static void setPreviousRowColorRgb(Color newColor) {
        Props.putInt(PREF_KEY_PREVIOUS_COLOR_RGB, newColor.getRGB());
    }

    public static int getPreviousColorRgb() {
        return Props.getInt(PREF_KEY_PREVIOUS_COLOR_RGB, -1);
    }
}

