/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.colorrows;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.gui.action.rowselectionwindow.CopyRowsToNewWindowService;

public class CopyColoredRowsToNewWindowCommand {
    private final DataSetViewerTable _table;
    private final ISession _session;

    public CopyColoredRowsToNewWindowCommand(DataSetViewerTable table, ISession session) {
        this._table = table;
        this._session = session;
    }

    public void execute() {
        Set<Integer> modelRowIndexes = this._table.getColoringService().getUserColorHandler().getAllColoredRows();
        TreeMap<Integer, Object[]> rowsSortedByViewIndex = new TreeMap<Integer, Object[]>();
        for (Integer modelRowIndex : modelRowIndexes) {
            rowsSortedByViewIndex.put(this._table.getSortableTableModel().transformToViewRow(modelRowIndex), this._table.getDataSetViewerTableModel().getRowAt(modelRowIndex));
        }
        new CopyRowsToNewWindowService(this._table, this._session).copyRowsToNewWindow(new ArrayList<Object[]>(rowsSortedByViewIndex.values()));
    }
}

