/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.colorrows;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.UserColorHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class GotoColorMenuController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GotoColorMenuController.class);
    private final JMenu _parentMenu = new JMenu(s_stringMgr.getString("GotoColorMenuController.goto.color"));

    public void createSubMenus(DataSetViewerTable table) {
        this._parentMenu.removeAll();
        UserColorHandler userColorHandler = table.getColoringService().getUserColorHandler();
        if (0 == userColorHandler.getColorByRow().size() && 0 == userColorHandler.getColorByCell().size()) {
            JMenuItem menuItem = new JMenuItem(s_stringMgr.getString("GotoColorMenuController.no.colored.rows"));
            menuItem.setEnabled(false);
            this._parentMenu.add(menuItem);
            return;
        }
        TreeMap<Integer, Color> colorByViewRowSorted = this.createColorByViewRowMapSortedByRow(table);
        for (Map.Entry<Integer, Color> viewRowColorEntry : colorByViewRowSorted.entrySet()) {
            JMenuItem menuItem = new JMenuItem(s_stringMgr.getString("GotoColorMenuController.row.number", viewRowColorEntry.getKey() + 1));
            menuItem.setBackground(viewRowColorEntry.getValue());
            menuItem.addActionListener(a -> this.onGotoLine(table, (Integer)viewRowColorEntry.getKey()));
            this._parentMenu.add(menuItem);
        }
    }

    private void onGotoLine(DataSetViewerTable table, Integer viewRow) {
        Rectangle visibleRect = table.getVisibleRect();
        Rectangle gotoRowRect = table.getCellRect(viewRow, 0, true);
        table.scrollRectToVisible(new Rectangle(visibleRect.x, gotoRowRect.y, visibleRect.width, 3 * visibleRect.height / 4));
    }

    private TreeMap<Integer, Color> createColorByViewRowMapSortedByRow(DataSetViewerTable table) {
        Integer minViewRow;
        Integer viewRow;
        HashMap<Color, Integer> minViewIndexByColor = new HashMap<Color, Integer>();
        UserColorHandler userColorHandler = table.getColoringService().getUserColorHandler();
        for (Map.Entry<Point, Color> entry : userColorHandler.getColorByCell().entrySet()) {
            viewRow = table.getSortableTableModel().transformToViewRow(entry.getKey().y);
            minViewRow = (Integer)minViewIndexByColor.get(entry.getValue());
            if (null != minViewRow && viewRow >= minViewRow) continue;
            minViewIndexByColor.put(entry.getValue(), viewRow);
        }
        for (Map.Entry<Serializable, Color> entry : userColorHandler.getColorByRow().entrySet()) {
            viewRow = table.getSortableTableModel().transformToViewRow((Integer)entry.getKey());
            minViewRow = (Integer)minViewIndexByColor.get(entry.getValue());
            if (null != minViewRow && viewRow >= minViewRow) continue;
            minViewIndexByColor.put(entry.getValue(), viewRow);
        }
        TreeMap<Integer, Color> colorByViewRowSorted = new TreeMap<Integer, Color>();
        for (Map.Entry colorViewRowEntry : minViewIndexByColor.entrySet()) {
            colorByViewRowSorted.put((Integer)colorViewRowEntry.getValue(), (Color)colorViewRowEntry.getKey());
        }
        return colorByViewRowSorted;
    }

    public JMenu getParentMenu() {
        return this._parentMenu;
    }
}

