/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.columndetails;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.SimpleDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableClickPosition;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.InStatColumnInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyInStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.columndetails.ColumnDetailsDialog;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class ColumnDetailsController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ColumnDetailsController.class);
    private ColumnDetailsDialog _dlg;
    private DataSetViewerTablePanel _columnsDetailsPanel;

    public ColumnDetailsController(DataSetViewerTable table, ISession session, TableClickPosition tableClickPosition) {
        try {
            SimpleDataSet columnDetailsDataSet = this.createColumnDetailsDataSet(table, session, tableClickPosition);
            if (null == columnDetailsDataSet) {
                return;
            }
            this._dlg = new ColumnDetailsDialog(GUIUtils.getOwningFrame(table), s_stringMgr.getString("ColumnDetailsController.title"));
            this._dlg.setDefaultCloseOperation(2);
            this._dlg.getContentPane().setLayout(new GridLayout(1, 1));
            this._columnsDetailsPanel = new DataSetViewerTablePanel();
            this._columnsDetailsPanel.init(null, null);
            this._columnsDetailsPanel.show(columnDetailsDataSet);
            this._dlg.getContentPane().add(new JScrollPane(this._columnsDetailsPanel.getComponent()));
            GUIUtils.enableCloseByEscape(this._dlg);
            GUIUtils.initLocation(this._dlg, 600, 180);
            this._dlg.setVisible(true);
        }
        catch (DataSetException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private SimpleDataSet createColumnDetailsDataSet(DataSetViewerTable table, ISession session, TableClickPosition tableClickPosition) {
        List<ColumnDisplayDefinition> selectedColDefs = this.getSelectedColDefs(table, session, tableClickPosition);
        if (selectedColDefs.isEmpty()) {
            return null;
        }
        ArrayList<ColumnDisplayDefinition> columnDisplayDefinitions = new ArrayList<ColumnDisplayDefinition>();
        columnDisplayDefinitions.add(new ColumnDisplayDefinition(30, s_stringMgr.getString("ColumnDetailsController.colName")));
        boolean hasTableNames = ColumnDetailsController.hasTableNames(selectedColDefs);
        ArrayList<String> tableNameRow = new ArrayList<String>();
        ArrayList<String> sqlTypeNameRow = new ArrayList<String>();
        ArrayList<String> nullableRow = new ArrayList<String>();
        ArrayList<String> columnSizeRow = new ArrayList<String>();
        ArrayList<String> scaleRow = new ArrayList<String>();
        ArrayList<String> precisionRow = new ArrayList<String>();
        for (ColumnDisplayDefinition selColDef : selectedColDefs) {
            columnDisplayDefinitions.add(new ColumnDisplayDefinition(30, selColDef.getColumnHeading()));
            if (hasTableNames) {
                ColumnDetailsController.addIfEmpty(tableNameRow, s_stringMgr.getString("ColumnDetailsController.tableName"));
                String tableName = "";
                if (null != selColDef.getResultMetaDataTable()) {
                    tableName = selColDef.getResultMetaDataTable().getTableName();
                }
                tableNameRow.add(StringUtilities.nullToEmpty(tableName));
            }
            ColumnDetailsController.addIfEmpty(sqlTypeNameRow, s_stringMgr.getString("ColumnDetailsController.sqlTypeName"));
            sqlTypeNameRow.add(selColDef.getSqlTypeName());
            ColumnDetailsController.addIfEmpty(nullableRow, s_stringMgr.getString("ColumnDetailsController.nullable"));
            nullableRow.add("" + selColDef.isNullable());
            ColumnDetailsController.addIfEmpty(columnSizeRow, s_stringMgr.getString("ColumnDetailsController.size"));
            columnSizeRow.add("" + selColDef.getColumnSize());
            ColumnDetailsController.addIfEmpty(scaleRow, s_stringMgr.getString("ColumnDetailsController.scale"));
            scaleRow.add("" + selColDef.getScale());
            ColumnDetailsController.addIfEmpty(precisionRow, s_stringMgr.getString("ColumnDetailsController.precision"));
            precisionRow.add("" + selColDef.getPrecision());
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        if (!tableNameRow.isEmpty()) {
            rows.add(tableNameRow.toArray());
        }
        rows.add(sqlTypeNameRow.toArray());
        rows.add(nullableRow.toArray());
        rows.add(columnSizeRow.toArray());
        rows.add(scaleRow.toArray());
        rows.add(precisionRow.toArray());
        SimpleDataSet colsDataSet = new SimpleDataSet(rows, columnDisplayDefinitions.toArray(new ColumnDisplayDefinition[0]));
        return colsDataSet;
    }

    private List<ColumnDisplayDefinition> getSelectedColDefs(DataSetViewerTable table, ISession session, TableClickPosition tableClickPosition) {
        int columnIndexAtX;
        TableColumnModel cm;
        ArrayList<InStatColumnInfo> inStatColumnInfos = new TableCopyInStatementCommand(table, session).getInStatColumnInfos();
        List<ColumnDisplayDefinition> colDefs = new ArrayList<ColumnDisplayDefinition>();
        if (!inStatColumnInfos.isEmpty()) {
            colDefs = inStatColumnInfos.stream().map(ici -> ici.getColDef()).collect(Collectors.toList());
        } else if (null != tableClickPosition && tableClickPosition.isClickedOnTableHeader() && (cm = table.getColumnModel()).getColumn(columnIndexAtX = cm.getColumnIndexAtX(tableClickPosition.getX())) instanceof ExtTableColumn) {
            colDefs.add(((ExtTableColumn)cm.getColumn(columnIndexAtX)).getColumnDisplayDefinition());
        }
        return colDefs;
    }

    private static void addIfEmpty(List<String> row, String rowName) {
        if (row.isEmpty()) {
            row.add(rowName);
        }
    }

    private static boolean hasTableNames(List<ColumnDisplayDefinition> colDefs) {
        for (ColumnDisplayDefinition colDef : colDefs) {
            String tableName;
            if (null == colDef.getResultMetaDataTable() || StringUtilities.isEmpty(tableName = colDef.getResultMetaDataTable().getTableName(), true)) continue;
            return true;
        }
        return false;
    }
}

