/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.copyasmarkdown;

import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowNumberTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.action.copyasmarkdown.CopyAsMarkDownResult;
import net.sourceforge.squirrel_sql.fw.gui.action.copyasmarkdown.RawDataTable;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.steppschuh.markdowngenerator.table.Table;

public class CopyAsMarkDown {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CopyAsMarkDown.class);

    public static String createMarkdownForSelectedCells(JTable table) {
        return CopyAsMarkDown._createMarkDownForSelectedCells(table, null);
    }

    public static CopyAsMarkDownResult createMarkdownForSelectedCellsIncludingRawData(JTable table) {
        RawDataTable rawDataTable = new RawDataTable();
        String markDownString = CopyAsMarkDown._createMarkDownForSelectedCells(table, rawDataTable);
        if (null == markDownString) {
            return CopyAsMarkDownResult.EMPTY;
        }
        return new CopyAsMarkDownResult(markDownString, rawDataTable);
    }

    private static String _createMarkDownForSelectedCells(JTable table, RawDataTable rawDataTable) {
        int nbrSelRows = table.getSelectedRowCount();
        int nbrSelCols = table.getSelectedColumnCount();
        int[] selRows = table.getSelectedRows();
        int[] selCols = table.getSelectedColumns();
        Integer rowNumberColIx = null;
        ArrayList<ColumnDisplayDefinition> columnDisplayDefinitions = new ArrayList<ColumnDisplayDefinition>();
        for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
            TableColumn col = table.getColumnModel().getColumn(selCols[colIdx]);
            if (col instanceof RowNumberTableColumn) {
                rowNumberColIx = colIdx;
                continue;
            }
            if (col instanceof ExtTableColumn) {
                columnDisplayDefinitions.add(((ExtTableColumn)col).getColumnDisplayDefinition());
                continue;
            }
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("TableCopyAsMarkdownCommand.failed.to.copy"));
            return null;
        }
        ColumnDisplayDefinition[] colDefs = columnDisplayDefinitions.toArray(new ColumnDisplayDefinition[columnDisplayDefinitions.size()]);
        String[] colNames = new String[colDefs.length];
        for (int i = 0; i < colDefs.length; ++i) {
            colNames[i] = colDefs[i].getColumnName();
        }
        Table.Builder tableBuilder = new Table.Builder();
        tableBuilder.addRow((Object[])colNames);
        if (null != rawDataTable) {
            rawDataTable.setColumnNames(colNames);
        }
        for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
            Object[] row = new Object[colDefs.length];
            int curIx = 0;
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                if (null != rowNumberColIx && colIdx == rowNumberColIx) continue;
                Object cellObj = table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                if (cellObj instanceof String && -1 < ((String)cellObj).indexOf(10)) {
                    int lineBreakPos = ((String)cellObj).indexOf(10);
                    row[curIx] = ((String)cellObj).substring(0, lineBreakPos);
                } else {
                    row[curIx] = null == cellObj ? "<null>" : cellObj;
                }
                ++curIx;
                if (null == rawDataTable) continue;
                rawDataTable.setCell(rowIdx, colIdx, cellObj);
            }
            tableBuilder.addRow(row);
        }
        Table markDownTable = tableBuilder.build();
        String markdownString = markDownTable.toString();
        int width = markdownString.indexOf(10);
        String line = StringUtilities.pad(width, '-') + "\n";
        return line + markdownString + "\n" + line;
    }
}

