/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.io.File;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportCellData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataRow;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.FileExportService;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.IDataExportWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.IExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public abstract class AbstractDataExportFileWriter
implements IDataExportWriter {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AbstractDataExportFileWriter.class);
    private final FileExportService _fileExportService;

    public AbstractDataExportFileWriter(File file, TableExportPreferences prefs, ProgressAbortCallback progressAbortCallback) {
        this._fileExportService = new FileExportService(file, prefs, progressAbortCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(IExportData exportData) throws Exception {
        try {
            this.beforeWorking(this._fileExportService.getFile());
            if (this._fileExportService.getPrefs().isWithHeaders()) {
                Iterator<String> headers = exportData.getHeaders();
                int colIdx = 0;
                this.beforeHeader();
                while (headers.hasNext()) {
                    String columnName = headers.next();
                    this.addHeaderCell(colIdx, columnName);
                    ++colIdx;
                }
                this.afterHeader();
            }
            Iterator<ExportDataRow> rows = exportData.getRows();
            this.progress(s_stringMgr.getString("AbstractDataExportFileWriter.beginWriting.file", this._fileExportService.getFile()));
            this.beforeRows();
            long rowsCount = 0L;
            NumberFormat nfRowCount = NumberFormat.getInstance();
            long begin = System.currentTimeMillis();
            while (rows.hasNext() && !this.isUserCanceled()) {
                ++rowsCount;
                ExportDataRow aRow = rows.next();
                if (this._fileExportService.isStatusUpdateNecessary()) {
                    long secondsPassed = (System.currentTimeMillis() - begin) / 1000L;
                    this.taskStatus(s_stringMgr.getString("AbstractDataExportFileWriter.numberOfRowsCompletedInSeconds", nfRowCount.format(rowsCount), secondsPassed));
                }
                this.beforeRow(aRow.getRowIndex());
                Iterator<ExportCellData> cells = aRow.getCells();
                while (cells.hasNext()) {
                    ExportCellData cell = cells.next();
                    this.addCell(cell);
                }
                this.afterRow();
            }
            this.progress(s_stringMgr.getString("AbstractDataExportFileWriter.finishedLoading", nfRowCount.format(rowsCount)));
            this.afterRows();
            this.progress(s_stringMgr.getString("AbstractDataExportFileWriter.closingTheFile"));
            this.afterWorking();
            this.progress(s_stringMgr.getString("AbstractDataExportFileWriter.done"));
            if (this.isUserCanceled()) {
                long l = -1L;
                return l;
            }
            long l = rowsCount;
            return l;
        }
        finally {
            exportData.close();
        }
    }

    public void beforeRows() {
    }

    public void afterRows() {
    }

    public void beforeRow(int rowIdx) throws Exception {
    }

    public void afterRow() throws Exception {
    }

    protected abstract void afterWorking() throws Exception;

    protected abstract void addCell(ExportCellData var1) throws Exception;

    protected void beforeHeader() throws Exception {
    }

    protected abstract void addHeaderCell(int var1, String var2) throws Exception;

    protected void afterHeader() throws Exception {
    }

    protected abstract void beforeWorking(File var1) throws Exception;

    public File getFile() {
        return this._fileExportService.getFile();
    }

    public void setFile(File file) {
        this._fileExportService.setFile(file);
    }

    public TableExportPreferences getPrefs() {
        return this._fileExportService.getPrefs();
    }

    public void setPrefs(TableExportPreferences prefs) {
        this._fileExportService.setPrefs(prefs);
    }

    protected void progress(String task) {
        this._fileExportService.progress(task);
    }

    protected void taskStatus(String status) {
        this._fileExportService.taskStatus(status);
    }

    protected boolean isUserCanceled() {
        return this._fileExportService.isUserCanceled();
    }

    public Charset getCharset() {
        return this._fileExportService.getCharset();
    }
}

