/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExcelCellColorer;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportCellData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataInfoList;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataRow;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.FileExportService;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.IExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DataExportExcelWriter {
    public static final String DEFAULT_EXCEL_EXPORT_SHEET_NAME = "Squirrel SQL Export";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataExportExcelWriter.class);
    private final FileExportService _fileExportService;
    private Workbook _workbook;
    private Sheet _sheet;
    private boolean withHeader = false;
    private HashMap<String, CellStyle> formatCache = null;

    public DataExportExcelWriter(File file, TableExportPreferences prefs, ProgressAbortCallback progressController) {
        this._fileExportService = new FileExportService(file, prefs, progressController);
    }

    public long write(ExportDataInfoList exportDataInfoList) throws Exception {
        long rowsCount = 0L;
        this._fileExportService.progress(s_stringMgr.getString("DataExportExcelWriter.beginWriting.file", this._fileExportService.getFile()));
        this.beforeWorking();
        for (ExportDataInfo exportDataInfo : exportDataInfoList.getExportDataInfos()) {
            this._sheet = this._workbook.createSheet(exportDataInfo.getExcelSheetTabName());
            rowsCount += this._writeExcelTab(exportDataInfo.getExportData());
        }
        this._fileExportService.progress(s_stringMgr.getString("DataExportExcelWriter.finishedLoading", NumberFormat.getInstance().format(rowsCount)));
        this._fileExportService.progress(s_stringMgr.getString("DataExportExcelWriter.closingTheFile"));
        this.afterWorking();
        this._fileExportService.progress(s_stringMgr.getString("DataExportExcelWriter.done"));
        this._fileExportService.setProgressFinished();
        if (this._fileExportService.isUserCanceled()) {
            return -1L;
        }
        return rowsCount;
    }

    private long _writeExcelTab(IExportData data) {
        if (this._fileExportService.getPrefs().isWithHeaders()) {
            Iterator<String> headers = data.getHeaders();
            int colIdx = 0;
            while (headers.hasNext()) {
                String columnName = headers.next();
                this.addHeaderCell(colIdx, columnName);
                ++colIdx;
            }
        }
        Iterator<ExportDataRow> rows = data.getRows();
        long rowsCount = 0L;
        long begin = System.currentTimeMillis();
        while (rows.hasNext() && !this._fileExportService.isUserCanceled()) {
            ++rowsCount;
            ExportDataRow aRow = rows.next();
            if (this._fileExportService.isStatusUpdateNecessary()) {
                long secondsPassed = (System.currentTimeMillis() - begin) / 1000L;
                this._fileExportService.taskStatus(s_stringMgr.getString("DataExportExcelWriter.numberOfRowsCompletedInSeconds", NumberFormat.getInstance().format(rowsCount), secondsPassed));
            }
            Iterator<ExportCellData> cells = aRow.getCells();
            while (cells.hasNext()) {
                ExportCellData cell = cells.next();
                this.addCell(cell);
            }
        }
        return rowsCount;
    }

    private Cell writeXlsCell(ColumnDisplayDefinition colDef, int colIdx, int curRow, Object cellObj) {
        Row row = this._sheet.getRow(curRow);
        if (row == null) {
            row = this._sheet.createRow(curRow);
        }
        Cell retVal = row.createCell(colIdx);
        if (null == cellObj || null == colDef) {
            retVal.setCellValue(this.getDataXLSAsString(cellObj));
            return retVal;
        }
        int colType = colDef.getSqlType();
        switch (colType) {
            case -7: 
            case 16: {
                retVal.setCellValue(((Boolean)cellObj).booleanValue());
                break;
            }
            case 4: {
                retVal.setCellValue((double)((Number)cellObj).intValue());
                break;
            }
            case -6: 
            case 5: {
                retVal.setCellValue((double)((Number)cellObj).shortValue());
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                retVal.setCellValue(((Number)cellObj).doubleValue());
                break;
            }
            case -5: {
                retVal.setCellValue((double)Long.parseLong(cellObj.toString()));
                break;
            }
            case 91: {
                this.makeTemporalCell(retVal, (Date)cellObj, "m/d/yy");
                break;
            }
            case 93: {
                this.makeTemporalCell(retVal, (Date)cellObj, "m/d/yy h:mm");
                break;
            }
            case 92: {
                this.makeTemporalCell(retVal, (Date)cellObj, "h:mm");
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                cellObj = CellComponentFactory.renderObject(cellObj, colDef);
                retVal.setCellValue(this.getDataXLSAsString(cellObj));
                break;
            }
            default: {
                cellObj = CellComponentFactory.renderObject(cellObj, colDef);
                retVal.setCellValue(this.getDataXLSAsString(cellObj));
            }
        }
        return retVal;
    }

    private void makeTemporalCell(Cell retVal, Date cellObj, String format) {
        CellStyle cellStyle;
        CreationHelper creationHelper = this._workbook.getCreationHelper();
        if (this.formatCache == null) {
            cellStyle = this._workbook.createCellStyle();
            cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(format));
            this.formatCache = new HashMap();
            this.formatCache.put(format, cellStyle);
        } else {
            cellStyle = this.formatCache.get(format);
            if (cellStyle == null) {
                cellStyle = this._workbook.createCellStyle();
                cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(format));
                this.formatCache.put(format, cellStyle);
            }
        }
        retVal.setCellStyle(cellStyle);
        if (null != cellObj) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(cellObj);
            retVal.setCellValue(calendar);
        }
    }

    private String getDataXLSAsString(Object cellObj) {
        if (cellObj == null) {
            return "";
        }
        return cellObj.toString().trim();
    }

    private void beforeWorking() {
        this._workbook = this._fileExportService.getPrefs().isFormatXLSOld() ? new HSSFWorkbook() : (this._fileExportService.getPrefs().isUseColoring() ? new XSSFWorkbook() : new SXSSFWorkbook(100));
    }

    private void addHeaderCell(int colIdx, String columnName) {
        this.withHeader = true;
        Row headerRow = this._sheet.getRow(0);
        if (headerRow == null) {
            headerRow = this._sheet.createRow(0);
        }
        Cell cell = headerRow.createCell(colIdx);
        cell.setCellValue(columnName);
    }

    private void addCell(ExportCellData cell) {
        Cell excelCell = this._fileExportService.getPrefs().isUseGlobalPrefsFormating() ? this.writeXlsCell(cell.getColumnDisplayDefinition(), cell.getColumnIndex(), this.calculateRowIdx(cell), cell.getObject()) : this.writeXlsCell(null, cell.getColumnIndex(), this.calculateRowIdx(cell), cell.getObject());
        ExcelCellColorer.color(excelCell, cell.getExcelExportColor());
    }

    private int calculateRowIdx(ExportCellData cell) {
        if (this.withHeader) {
            return cell.getRowIndex() + 1;
        }
        return cell.getRowIndex();
    }

    private void afterWorking() throws Exception {
        FileOutputStream out = new FileOutputStream(this._fileExportService.getFile());
        this._workbook.write((OutputStream)out);
        out.close();
        if (this._workbook instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook)this._workbook).dispose();
        }
    }
}

