/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.Window;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.EditableComboBoxHandler;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.EditExcelTabOrFileNameDlg;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import org.apache.commons.lang3.StringUtils;

public class EditExcelTabOrFileNameCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(EditExcelTabOrFileNameCtrl.class);
    private final EditExcelTabOrFileNameDlg _dlg;
    private final EditableComboBoxHandler _editableComboBoxHandler;
    private String _previousSqlResultName;
    private boolean _ok;

    public EditExcelTabOrFileNameCtrl(Window owningWindow, String sqlResultName) {
        this._dlg = new EditExcelTabOrFileNameDlg(owningWindow);
        this._previousSqlResultName = sqlResultName;
        this._editableComboBoxHandler = new EditableComboBoxHandler(this._dlg.cboSqlResultName, "fileExport.EditExcelTabOrFileNameCtrl_", 10, this._previousSqlResultName);
        this._dlg.btnOk.addActionListener(e -> this.onOk());
        this._dlg.btnCancel.addActionListener(e -> this.close());
        GUIUtils.enableCloseByEscape(this._dlg);
        GUIUtils.initLocation(this._dlg, 500, 130);
        this._editableComboBoxHandler.focus();
        this._dlg.setVisible(true);
    }

    private void onOk() {
        this._ok = true;
        this.close();
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    public boolean isOk() {
        return this._ok;
    }

    public String getNewSqlResultNameFileNormalized() {
        if (StringUtilities.isEmpty(this._editableComboBoxHandler.getItem(), true)) {
            return this._previousSqlResultName;
        }
        String ret = StringUtilities.fileNameNormalize(this._editableComboBoxHandler.getItem());
        if (!StringUtils.equals((CharSequence)ret, (CharSequence)this._editableComboBoxHandler.getItem())) {
            String msg = s_stringMgr.getString("EditExcelTabOrFileNameCtrl.normalized.to.file.name", this._editableComboBoxHandler.getItem(), ret);
            Main.getApplication().getMessageHandler().showMessage(msg);
        }
        if (!StringUtils.equals((CharSequence)ret, (CharSequence)this._previousSqlResultName)) {
            this._editableComboBoxHandler.addOrReplaceCurrentItem(ret);
        }
        return ret;
    }
}

