/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.Color;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class ExcelCellColorer {
    public static void color(Cell excelCell, Color color) {
        if (null == color) {
            return;
        }
        if (excelCell instanceof XSSFCell) {
            ExcelCellColorer.colorXSSFCell((XSSFCell)excelCell, color);
        } else if (excelCell instanceof SXSSFCell || excelCell instanceof HSSFCell) {
            // empty if block
        }
    }

    private static void colorXSSFCell(XSSFCell excelCell, Color color) {
        XSSFCellStyle cellStyle = excelCell.getSheet().getWorkbook().createCellStyle();
        XSSFColor xssfColor = new XSSFColor(color);
        cellStyle.setFillForegroundColor(xssfColor);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        excelCell.setCellStyle((CellStyle)cellStyle);
    }
}

