/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExcelTabOrFileNamesContainerJsonBean;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.NamedExcelTabOrFileNamesJsonBean;
import net.sourceforge.squirrel_sql.fw.util.JsonMarshalUtil;
import org.apache.commons.lang3.StringUtils;

public class ExcelTabOrFileNamesDao {
    public static void addOrReplaceSavedName(String name, List<String> excelTabOrFileNames) {
        List<NamedExcelTabOrFileNamesJsonBean> beans = ExcelTabOrFileNamesDao.readBeanList();
        for (NamedExcelTabOrFileNamesJsonBean bean : beans) {
            if (!StringUtils.containsIgnoreCase((CharSequence)bean.getName(), (CharSequence)name)) continue;
            bean.setName(name);
            bean.setExcelTabOrFileNames(excelTabOrFileNames);
            ExcelTabOrFileNamesDao.writeBeanList(beans);
            return;
        }
        NamedExcelTabOrFileNamesJsonBean bean = new NamedExcelTabOrFileNamesJsonBean();
        bean.setName(name);
        bean.setExcelTabOrFileNames(excelTabOrFileNames);
        beans.add(0, bean);
        while (10 < beans.size()) {
            beans.remove(beans.size() - 1);
        }
        ExcelTabOrFileNamesDao.writeBeanList(beans);
    }

    private static void writeBeanList(List<NamedExcelTabOrFileNamesJsonBean> beans) {
        ExcelTabOrFileNamesContainerJsonBean containerBean = new ExcelTabOrFileNamesContainerJsonBean();
        containerBean.setNamedExcelTabOrFileNamesJsonBeans(beans);
        File file = new ApplicationFiles().getExcelTabOrFileNamesJsonBeanFile();
        JsonMarshalUtil.writeObjectToFile(file, containerBean);
    }

    private static List<NamedExcelTabOrFileNamesJsonBean> readBeanList() {
        ExcelTabOrFileNamesContainerJsonBean containerBean = new ExcelTabOrFileNamesContainerJsonBean();
        File file = new ApplicationFiles().getExcelTabOrFileNamesJsonBeanFile();
        if (file.exists()) {
            containerBean = JsonMarshalUtil.readObjectFromFileSave(file, ExcelTabOrFileNamesContainerJsonBean.class, new ExcelTabOrFileNamesContainerJsonBean());
        }
        List<NamedExcelTabOrFileNamesJsonBean> beans = containerBean.getNamedExcelTabOrFileNamesJsonBeans();
        return beans;
    }

    public static List<String> getSavedNames() {
        return ExcelTabOrFileNamesDao.readBeanList().stream().map(b -> b.getName()).collect(Collectors.toList());
    }

    public static List<String> getExcelTabOrFileNames(String savedName) {
        Optional<NamedExcelTabOrFileNamesJsonBean> first = ExcelTabOrFileNamesDao.readBeanList().stream().filter(b -> StringUtils.containsIgnoreCase((CharSequence)b.getName(), (CharSequence)savedName)).findFirst();
        if (first.isEmpty()) {
            throw new IllegalStateException("Saved name \"" + savedName + "\" does not exist");
        }
        return first.get().getExcelTabOrFileNames();
    }
}

