/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.squirrel_sql.fw.gui.EditableComboBoxHandler;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDialogType;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDlg;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportSourceAccess;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.FileEndings;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.LineSeparator;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferencesDAO;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportSelectionPanelController;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import org.apache.commons.lang3.StringUtils;

public class ExportController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExportController.class);
    private ExportDlg _dlg;
    private final EditableComboBoxHandler _cboFileHandler;
    private final EditableComboBoxHandler _cboCommandHandler;
    private boolean _ok = false;
    private Window _owner;
    private ExportDialogType _exportDialogType;
    private TableExportSelectionPanelController _exportSelectionPanelController;

    ExportController(ExportSourceAccess exportSourceAccess, Window owner, ExportDialogType exportDialogType) {
        this._owner = owner;
        this._exportDialogType = exportDialogType;
        this._exportSelectionPanelController = new TableExportSelectionPanelController(exportSourceAccess, exportDialogType);
        this._dlg = new ExportDlg(owner, this._exportSelectionPanelController.getPanel(), this._exportDialogType);
        this._cboFileHandler = new EditableComboBoxHandler(this._dlg.cboFile, "fileexport.ExportDlg.cboFile");
        this._cboCommandHandler = new EditableComboBoxHandler(this._dlg.cboCommand, "fileexport.ExportDlg.cboCommand");
        this.initData();
        this.initListeners();
        this._dlg.txtSeparatorChar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ExportController.this.onSeparatorCharChanged(e);
            }
        });
        this._cboFileHandler.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportController.this.updateDestinationInfo();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportController.this.updateDestinationInfo();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExportController.this.updateDestinationInfo();
            }
        });
        this.updateDestinationInfo();
        this._dlg.getRootPane().setDefaultButton(this._dlg.btnOk);
        GUIUtils.enableCloseByEscape(this._dlg);
        GUIUtils.initLocation(this._dlg, 500, 880);
    }

    private void updateDestinationInfo() {
        this._exportSelectionPanelController.updateExportDestinationInfo(this._cboFileHandler.getItem(), this._dlg.radFormatXLSX.isSelected() || this._dlg.radFormatXLS.isSelected());
    }

    public void showDialog() {
        this._dlg.setVisible(true);
    }

    private void onSeparatorCharChanged(KeyEvent e) {
        SwingUtilities.invokeLater(() -> {
            String text = this._dlg.txtSeparatorChar.getText();
            if (null != text && 1 < text.length()) {
                this._dlg.txtSeparatorChar.setText(text.substring(0, 1));
                Toolkit.getDefaultToolkit().beep();
            }
        });
    }

    private void initListeners() {
        this._dlg.btnOk.addActionListener(e -> this.onOK());
        this._dlg.btnCancel.addActionListener(e -> this.closeDlg());
        this._dlg.radFormatCSV.addActionListener(e -> this.onFormat(true));
        this._dlg.radFormatXLSX.addActionListener(e -> this.onFormat(true));
        this._dlg.radFormatXLS.addActionListener(e -> this.onFormat(true));
        this._dlg.radFormatXML.addActionListener(e -> this.onFormat(true));
        this._dlg.radFormatJSON.addActionListener(e -> this.onFormat(true));
        this._dlg.chkSeparatorTab.addActionListener(e -> this.onFormat(false));
        this._dlg.chkExecCommand.addActionListener(e -> this.onChkExecCommand());
        this._dlg.btnFile.addActionListener(e -> this.onFile());
        this._dlg.btnCommandFile.addActionListener(e -> this.onCommandFile());
    }

    private void onFormat(boolean replaceEnding) {
        if (this._dlg.radFormatCSV.isSelected()) {
            this._dlg.lblSeparator.setEnabled(true);
            this._dlg.chkSeparatorTab.setEnabled(true);
            this._dlg.txtSeparatorChar.setEnabled(true);
            this._dlg.lblCharset.setEnabled(true);
            this._dlg.cboCharsets.setEnabled(true);
            this._dlg.lblLineSeparator.setEnabled(true);
            this._dlg.cboLineSeparators.setEnabled(true);
            this._dlg.chkUseColoring.setEnabled(false);
            this._dlg.btnUseColoringInfo.setEnabled(false);
            if (this._dlg.chkSeparatorTab.isSelected()) {
                this._dlg.txtSeparatorChar.setText(null);
                this._dlg.txtSeparatorChar.setEnabled(false);
                this._dlg.lblSeparator.setEnabled(false);
            } else {
                this._dlg.txtSeparatorChar.setEnabled(true);
                this._dlg.lblSeparator.setEnabled(true);
            }
            if (replaceEnding) {
                this.replaceFileEnding();
            }
        } else if (this._dlg.radFormatXLSX.isSelected() || this._dlg.radFormatXLS.isSelected()) {
            this._dlg.lblSeparator.setEnabled(false);
            this._dlg.lblCharset.setEnabled(false);
            this._dlg.cboCharsets.setEnabled(false);
            this._dlg.chkSeparatorTab.setEnabled(false);
            this._dlg.txtSeparatorChar.setEnabled(false);
            this._dlg.lblLineSeparator.setEnabled(false);
            this._dlg.cboLineSeparators.setEnabled(false);
            this._dlg.chkUseColoring.setEnabled(this._dlg.radFormatXLSX.isSelected());
            this._dlg.btnUseColoringInfo.setEnabled(this._dlg.radFormatXLSX.isSelected());
            if (replaceEnding) {
                this.replaceFileEnding();
            }
        } else if (this._dlg.radFormatXML.isSelected() || this._dlg.radFormatJSON.isSelected()) {
            this._dlg.lblSeparator.setEnabled(false);
            this._dlg.lblCharset.setEnabled(true);
            this._dlg.cboCharsets.setEnabled(true);
            this._dlg.chkSeparatorTab.setEnabled(false);
            this._dlg.txtSeparatorChar.setEnabled(false);
            this._dlg.lblLineSeparator.setEnabled(false);
            this._dlg.cboLineSeparators.setEnabled(false);
            this._dlg.chkUseColoring.setEnabled(false);
            this._dlg.btnUseColoringInfo.setEnabled(false);
            if (replaceEnding) {
                this.replaceFileEnding();
            }
        } else {
            throw new IllegalStateException("No valid output format");
        }
        this.updateDestinationInfo();
    }

    private void replaceFileEnding() {
        String newEnding;
        if (this._dlg.radFormatCSV.isSelected()) {
            newEnding = FileEndings.CSV.get();
        } else if (this._dlg.radFormatXLSX.isSelected()) {
            newEnding = FileEndings.XLSX.get();
        } else if (this._dlg.radFormatXLS.isSelected()) {
            newEnding = FileEndings.XLS.get();
        } else if (this._dlg.radFormatXML.isSelected()) {
            newEnding = FileEndings.XML.get();
        } else if (this._dlg.radFormatJSON.isSelected()) {
            newEnding = FileEndings.JSON.get();
        } else {
            throw new IllegalStateException("No valid output format");
        }
        String file = this._cboFileHandler.getItem();
        if (null == file || 0 == file.trim().length() || file.toUpperCase().endsWith("." + newEnding.toUpperCase())) {
            return;
        }
        Object newFile = -1 == (file = file.trim()).lastIndexOf(".") || file.lastIndexOf(".") < file.lastIndexOf(File.separator) ? file + "." + newEnding : (file.lastIndexOf(".") > file.lastIndexOf(File.separator) ? (FileEndings.fileEndsWithOneOf(file) ? file.substring(0, file.lastIndexOf(".")) + "." + newEnding : file + "." + newEnding) : file);
        this._cboFileHandler.addOrReplaceCurrentItem((String)newFile);
    }

    private void onCommandFile() {
        JFileChooser chooser = new JFileChooser(System.getProperties().getProperty("user.home"));
        chooser.setFileSelectionMode(2);
        chooser.setDialogTitle(s_stringMgr.getString("TableExportCsvController.commandChooserTitel"));
        if (0 != chooser.showDialog(this._dlg, s_stringMgr.getString("TableExportCsvController.commandChooserButton"))) {
            return;
        }
        if (null != chooser.getSelectedFile()) {
            this._cboCommandHandler.addOrReplaceCurrentItem(chooser.getSelectedFile().getPath() + " %file");
        }
    }

    private void onFile() {
        File csvFile;
        File parentFile;
        JFileChooser chooser = null;
        String csvFileName = this._cboFileHandler.getItem();
        if (null != csvFileName && 0 < csvFileName.trim().length() && null != (parentFile = (csvFile = new File(csvFileName)).getParentFile()) && parentFile.exists()) {
            chooser = new JFileChooser(parentFile);
        }
        if (null == chooser) {
            chooser = new JFileChooser(System.getProperties().getProperty("user.home"));
        }
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(s_stringMgr.getString("TableExportCsvController.fileChooserTitel"));
        if (0 != chooser.showDialog(this._dlg, s_stringMgr.getString("TableExportCsvController.fileChooserButton"))) {
            return;
        }
        if (null != chooser.getSelectedFile()) {
            this._cboFileHandler.addOrReplaceCurrentItem(chooser.getSelectedFile().getPath());
        }
    }

    private void onOK() {
        String msg;
        String command;
        String sepChar;
        if (!this.warnIfExcel()) {
            return;
        }
        String singleExportFileName = this._cboFileHandler.getItem();
        if (StringUtilities.isEmpty(singleExportFileName, true)) {
            String msg2 = s_stringMgr.getString("TableExportCsvController.noFile");
            JOptionPane.showMessageDialog(this._dlg, msg2);
            return;
        }
        if (!(this._dlg.chkSeparatorTab.isSelected() || null != (sepChar = this._dlg.txtSeparatorChar.getText()) && 1 == sepChar.trim().length())) {
            String msg3 = s_stringMgr.getString("TableExportCsvController.invalidSeparator");
            JOptionPane.showMessageDialog(this._dlg, msg3);
            return;
        }
        if (this._dlg.chkExecCommand.isSelected() && (null == (command = this._cboCommandHandler.getItem()) || 0 == command.trim().length())) {
            String msg4 = s_stringMgr.getString("TableExportCsvController.noCommand");
            JOptionPane.showMessageDialog(this._dlg, msg4);
            return;
        }
        if (new File(singleExportFileName).exists() && !this.isExportingMultipleFiles() && 0 != JOptionPane.showConfirmDialog(this._dlg, msg = s_stringMgr.getString("TableExportCsvController.replaceFile"))) {
            return;
        }
        TableExportPreferences tableExportPreferences = new TableExportPreferences();
        this.writeControlsToPrefs(tableExportPreferences);
        TableExportPreferencesDAO.savePreferences(tableExportPreferences);
        this._ok = true;
        this.closeDlg();
    }

    private boolean isExportingMultipleFiles() {
        return this._exportSelectionPanelController.isExportMultipleSQLResults() && false == (this._dlg.radFormatXLS.isSelected() || this._dlg.radFormatXLSX.isSelected());
    }

    private boolean warnIfExcel() {
        String msg;
        int option;
        return !this._dlg.radFormatXLS.isSelected() || !this._exportDialogType.isWarnIfExcel() || (option = JOptionPane.showConfirmDialog(this._dlg, msg = s_stringMgr.getString("TableExportCsvController.warnIfExcel"), null, 2)) == 0;
    }

    private void writeControlsToPrefs(TableExportPreferences prefs) {
        prefs.setFile(this._cboFileHandler.getItem());
        this._cboFileHandler.saveCurrentItem();
        prefs.setEncoding(this._dlg.cboCharsets.getSelectedItem().toString());
        prefs.setWithHeaders(this._dlg.chkWithHeaders.isSelected());
        prefs.setFormatCSV(this._dlg.radFormatCSV.isSelected());
        prefs.setFormatXLS(this._dlg.radFormatXLSX.isSelected());
        prefs.setUseColoring(this._dlg.chkUseColoring.isSelected());
        prefs.setFormatXLSOld(this._dlg.radFormatXLS.isSelected());
        prefs.setFormatXML(this._dlg.radFormatXML.isSelected());
        prefs.setFormatJSON(this._dlg.radFormatJSON.isSelected());
        prefs.setSeperatorTab(this._dlg.chkSeparatorTab.isSelected());
        prefs.setSeperatorChar(this._dlg.txtSeparatorChar.getText());
        prefs.setLineSeperator(((LineSeparator)((Object)this._dlg.cboLineSeparators.getSelectedItem())).name());
        this._exportSelectionPanelController.writeControlsToPrefs(prefs);
        prefs.setUseGlobalPrefsFormating(this._dlg.radUseGlobalPrefsFormating.isSelected());
        prefs.setExecuteCommand(this._dlg.chkExecCommand.isSelected());
        prefs.setCommand(this._cboCommandHandler.getItem());
        this._cboCommandHandler.saveCurrentItem();
    }

    private void initData() {
        TableExportPreferences prefs = TableExportPreferencesDAO.loadPreferences();
        if (this.formatIsNewXlsx(prefs)) {
            this._cboFileHandler.addOrReplaceCurrentItem(this.replaceXlsByXlsx(prefs.getFile()));
        } else {
            this._cboFileHandler.addOrReplaceCurrentItem(prefs.getFile());
        }
        this._dlg.chkUseColoring.setSelected(prefs.isUseColoring());
        this._dlg.cboCharsets.setSelectedItem(prefs.getEncoding());
        this._dlg.chkWithHeaders.setSelected(prefs.isWithHeaders());
        this._dlg.chkSeparatorTab.setSelected(prefs.isSeperatorTab());
        if (!this._dlg.chkSeparatorTab.isSelected()) {
            this._dlg.txtSeparatorChar.setText(prefs.getSeperatorChar());
        }
        if (prefs.isFormatCSV()) {
            this._dlg.radFormatCSV.setSelected(true);
        } else if (this.formatIsNewXlsx(prefs)) {
            this._dlg.radFormatXLSX.setSelected(true);
        } else if (prefs.isFormatXLSOld()) {
            this._dlg.radFormatXLS.setSelected(true);
        } else if (prefs.isFormatXML()) {
            this._dlg.radFormatXML.setSelected(true);
        } else if (prefs.isFormatJSON()) {
            this._dlg.radFormatJSON.setSelected(true);
        } else {
            this._dlg.radFormatCSV.setSelected(true);
        }
        this._exportSelectionPanelController.initPanel(prefs);
        this.onFormat(false);
        if (prefs.isUseGlobalPrefsFormating()) {
            this._dlg.radUseGlobalPrefsFormating.setSelected(true);
        } else {
            this._dlg.radUseDefaultFormating.setSelected(true);
        }
        this._dlg.chkExecCommand.setSelected(prefs.isExecuteCommand());
        this.onChkExecCommand();
        this._cboCommandHandler.addOrReplaceCurrentItem(prefs.getCommand());
        LineSeparator preferredLineSeparator = LineSeparator.valueOf(prefs.getLineSeperator());
        this._dlg.cboLineSeparators.setSelectedItem((Object)preferredLineSeparator);
    }

    private boolean formatIsNewXlsx(TableExportPreferences preferences) {
        return preferences.isFormatXLS();
    }

    private String replaceXlsByXlsx(String fileName) {
        String oldXlsSuffix = ".xls";
        if (null != fileName && ((String)fileName).toLowerCase().endsWith(oldXlsSuffix)) {
            fileName = ((String)fileName).substring(0, ((String)fileName).length() - oldXlsSuffix.length()) + ".xlsx";
        }
        return fileName;
    }

    private void onChkExecCommand() {
        this._dlg.cboCommand.setEnabled(this._dlg.chkExecCommand.isSelected());
        this._dlg.btnCommandFile.setEnabled(this._dlg.chkExecCommand.isSelected());
    }

    private void closeDlg() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    boolean isOK() {
        return this._ok;
    }

    File getSingleExportTargetFile() {
        return new File(this._cboFileHandler.getItem());
    }

    public String getSeparatorChar() {
        if (this._dlg.chkSeparatorTab.isSelected()) {
            return "\t";
        }
        return this._dlg.txtSeparatorChar.getText();
    }

    String getCommand(File firstExportedFile) {
        if (this._dlg.chkExecCommand.isSelected()) {
            return StringUtils.replace((String)this._cboCommandHandler.getItem(), (String)"%file", (String)firstExportedFile.getAbsolutePath());
        }
        return null;
    }

    public Window getOwningWindow() {
        return this._owner;
    }

    public boolean isUITableMissingBlobData() {
        return this._exportSelectionPanelController.getExportSourceAccess().isUITableMissingBlobData(this.getSeparatorChar());
    }

    public ExportSourceAccess getExportSourceAccess() {
        return this._exportSelectionPanelController.getExportSourceAccess();
    }
}

