/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.Window;
import java.io.File;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportController;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataException;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataInfoList;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.MsExcelExportDataCreator;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.MsExcelWorkbook;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferencesDAO;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;

public class ExportControllerProxy {
    private ExportController _exportController;
    private Window _owningWindow;
    private MsExcelWorkbook _excelWorkbook;
    private MsExcelExportDataCreator _msExcelExportDataCreator;

    public ExportControllerProxy(Window owningWindow, MsExcelWorkbook excelWorkbook, MsExcelExportDataCreator msExcelExportDataCreator) {
        this._owningWindow = owningWindow;
        this._excelWorkbook = excelWorkbook;
        this._msExcelExportDataCreator = msExcelExportDataCreator;
    }

    public ExportControllerProxy(ExportController exportController) {
        this._exportController = exportController;
    }

    public boolean isOK() {
        if (null != this._exportController) {
            return this._exportController.isOK();
        }
        return true;
    }

    public boolean isUITableMissingBlobData() {
        if (null != this._exportController) {
            return this._exportController.isUITableMissingBlobData();
        }
        return false;
    }

    public Window getOwningWindow() {
        if (null != this._exportController) {
            return this._exportController.getOwningWindow();
        }
        return this._owningWindow;
    }

    public File getSingleExportTargetFile() {
        if (null != this._exportController) {
            return this._exportController.getSingleExportTargetFile();
        }
        return this._excelWorkbook.getWorkbookFile();
    }

    public ExportDataInfoList createExportData(ProgressAbortCallback progressAbortCallback) throws ExportDataException {
        if (null != this._exportController) {
            return this._exportController.getExportSourceAccess().createExportData(progressAbortCallback);
        }
        return this._msExcelExportDataCreator.createExportData(this._excelWorkbook, progressAbortCallback);
    }

    public String getCommand(File firstExportedFile) {
        if (null != this._exportController) {
            return this._exportController.getCommand(firstExportedFile);
        }
        return null;
    }

    public TableExportPreferences getPreferences() {
        if (null != this._exportController) {
            return this._exportController.getExportSourceAccess().getPreferences();
        }
        TableExportPreferences prefs = TableExportPreferencesDAO.loadPreferences();
        prefs.setUseColoring(false);
        return prefs;
    }

    public boolean isShowExportCompleteAsDialog() {
        return null != this._exportController;
    }
}

