/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.io.File;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.FileEndings;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.IExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.MultipleSqlResultExportDestinationInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class ExportDataInfo {
    private IExportData _exportData;
    private String _exportNameFileNormalized;
    private MultipleSqlResultExportDestinationInfo _multipleSqlResultExportDestinationInfo;

    public ExportDataInfo(IExportData exportData) {
        this(exportData, null);
    }

    public ExportDataInfo(IExportData exportData, String exportNameFileNormalized) {
        this._exportData = exportData;
        this._exportNameFileNormalized = exportNameFileNormalized;
    }

    public IExportData getExportData() {
        return this._exportData;
    }

    public void setMultipleSqlResultExportDestinationInfo(MultipleSqlResultExportDestinationInfo multipleSqlResultExportDestinationInfo) {
        this._multipleSqlResultExportDestinationInfo = multipleSqlResultExportDestinationInfo;
    }

    public File getFile(TableExportPreferences prefs) {
        if (StringUtilities.isEmpty(this._exportNameFileNormalized, true) || null == this._multipleSqlResultExportDestinationInfo) {
            return new File(prefs.getFile());
        }
        if (this._multipleSqlResultExportDestinationInfo.isDestinationExcel()) {
            return this._multipleSqlResultExportDestinationInfo.getExcelExportFile();
        }
        String fileNameWithExtension = this._exportNameFileNormalized + "." + FileEndings.getByTableExportPreferences(prefs);
        return new File(this._multipleSqlResultExportDestinationInfo.getExportDir(), fileNameWithExtension);
    }

    public String getExcelSheetTabName() {
        if (StringUtilities.isEmpty(this._exportNameFileNormalized, true)) {
            return "Squirrel SQL Export";
        }
        return this._exportNameFileNormalized;
    }
}

