/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.io.File;
import java.util.Collections;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.IExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.MultipleSqlResultExportDestinationInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;

public class ExportDataInfoList {
    public static final ExportDataInfoList EMPTY = new ExportDataInfoList(Collections.EMPTY_LIST);
    private final List<ExportDataInfo> _exportDataInfos;
    private MultipleSqlResultExportDestinationInfo _multipleSqlResultExportDestinationInfo;

    public static ExportDataInfoList single(IExportData data) {
        return new ExportDataInfoList(List.of(new ExportDataInfo(data)));
    }

    private ExportDataInfoList(List<ExportDataInfo> exportDataInfos) {
        this(exportDataInfos, null);
    }

    public ExportDataInfoList(List<ExportDataInfo> exportDataInfos, MultipleSqlResultExportDestinationInfo multipleSqlResultExportDestinationInfo) {
        this._exportDataInfos = exportDataInfos;
        this._exportDataInfos.forEach(edi -> edi.setMultipleSqlResultExportDestinationInfo(multipleSqlResultExportDestinationInfo));
        this._multipleSqlResultExportDestinationInfo = multipleSqlResultExportDestinationInfo;
    }

    public MultipleSqlResultExportDestinationInfo getMultipleSqlResultExportDestinationInfo() {
        return this._multipleSqlResultExportDestinationInfo;
    }

    public List<ExportDataInfo> getExportDataInfos() {
        return this._exportDataInfos;
    }

    public boolean isEmpty() {
        return this._exportDataInfos.isEmpty();
    }

    public File getFirstExportFile(TableExportPreferences prefs) {
        if (this.isEmpty()) {
            return null;
        }
        return this._exportDataInfos.get(0).getFile(prefs);
    }

    public File getSingleExportFile(TableExportPreferences prefs) {
        return this.getFirstExportFile(prefs);
    }
}

