/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.charset.Charset;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDialogType;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportInfoDlg;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.LineSeparator;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.SmallToolTipInfoButton;
import net.sourceforge.squirrel_sql.fw.resources.LibraryResources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ExportDlg
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExportDlg.class);
    JComboBox cboFile;
    JButton btnFile;
    JCheckBox chkWithHeaders;
    JRadioButton radFormatCSV;
    JRadioButton radFormatXLSX;
    JCheckBox chkUseColoring;
    SmallToolTipInfoButton btnUseColoringInfo;
    JRadioButton radFormatXLS;
    JRadioButton radFormatXML;
    JRadioButton radFormatJSON;
    JLabel lblSeparator;
    JLabel lblLineSeparator;
    JLabel lblCharset;
    JTextField txtSeparatorChar;
    JTextField txtLineSeparatorChar;
    JCheckBox chkSeparatorTab;
    JCheckBox chkPlatformLineSeparator;
    JRadioButton radUseGlobalPrefsFormating;
    JRadioButton radUseDefaultFormating;
    JCheckBox chkExecCommand;
    JComboBox cboCommand;
    JButton btnCommandFile;
    JButton btnOk;
    JButton btnCancel;
    JComboBox cboCharsets;
    JComboBox cboLineSeparators;

    public ExportDlg(Window owner, JPanel exportSelectionPanel, ExportDialogType exportDialogType) {
        super(owner);
        this.setModal(true);
        this.setTitle(s_stringMgr.getString("TableExportCSVDlg.exportTitleNew"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.getContentPane().add((Component)new JLabel(s_stringMgr.getString("TableExportCsvDlg.exportCsvFile")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0);
        this.getContentPane().add(this.getFilePanel(), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.getExportFormatPanel(exportDialogType.isEnableColoring()), gbc);
        this.chkWithHeaders = new JCheckBox(s_stringMgr.getString("TableExportCsvDlg.withHeaders"));
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.chkWithHeaders, gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 10, 5, 5), 0, 0);
        this.getContentPane().add(this.getSeparatorPanel(), gbc);
        gbc = new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 18, 1, new Insets(15, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)exportSelectionPanel, gbc);
        gbc = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(15, 5, 5, 5), 0, 0);
        this.getContentPane().add(this.getFormattingPanel(), gbc);
        this.chkExecCommand = new JCheckBox(s_stringMgr.getString("TableExportCsvDlg.executeCommand"));
        gbc = new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.chkExecCommand, gbc);
        gbc = new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 10, 5, 5), 0, 0);
        this.getContentPane().add(this.getCommandPanel(), gbc);
        gbc = new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 18, 2, new Insets(15, 5, 5, 5), 0, 0);
        this.getContentPane().add(this.getButtonPanel(), gbc);
    }

    private JPanel getExportFormatPanel(boolean enableColoring) {
        JPanel ret = new JPanel(new GridBagLayout());
        this.radFormatCSV = new JRadioButton(s_stringMgr.getString("TableExportCsvDlg.formatCSV"));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0);
        ret.add((Component)this.radFormatCSV, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0);
        ret.add((Component)this.createXLSXPanel(enableColoring), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0);
        this.radFormatXLS = new JRadioButton(s_stringMgr.getString("TableExportCsvDlg.formatXLS"));
        ret.add((Component)this.radFormatXLS, gbc);
        this.radFormatXML = new JRadioButton(s_stringMgr.getString("TableExportCsvDlg.formatXML"));
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.radFormatXML, gbc);
        this.radFormatJSON = new JRadioButton(s_stringMgr.getString("TableExportCsvDlg.formatJSON"));
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.radFormatJSON, gbc);
        gbc = new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radFormatCSV);
        bg.add(this.radFormatXLSX);
        bg.add(this.radFormatXLS);
        bg.add(this.radFormatXML);
        bg.add(this.radFormatJSON);
        ret.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("TableExportCsvDlg.export.format.title")));
        return ret;
    }

    private JPanel createXLSXPanel(boolean enableColoring) {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.radFormatXLSX = new JRadioButton(s_stringMgr.getString("TableExportCsvDlg.formatXLSX"));
        ret.add((Component)this.radFormatXLSX, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.chkUseColoring = new JCheckBox(s_stringMgr.getString("TableExportCsvDlg.coloring.checkbox"));
        this.chkUseColoring.setToolTipText(s_stringMgr.getString("TableExportCsvDlg.coloring.info.button"));
        if (enableColoring) {
            ret.add((Component)this.chkUseColoring, gbc);
        }
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.btnUseColoringInfo = new SmallToolTipInfoButton(s_stringMgr.getString("TableExportCsvDlg.coloring.info.button"));
        if (enableColoring) {
            ret.add((Component)this.btnUseColoringInfo.getButton(), gbc);
        }
        return ret;
    }

    private Component getFormattingPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        this.radUseGlobalPrefsFormating = new JRadioButton(s_stringMgr.getString("TableExportCsvDlg.useGlobalPrefsFormatingExcel"));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0);
        ret.add((Component)this.radUseGlobalPrefsFormating, gbc);
        this.radUseDefaultFormating = new JRadioButton(s_stringMgr.getString("TableExportCsvDlg.useDefaultFormating"));
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.radUseDefaultFormating, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 2, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radUseGlobalPrefsFormating);
        bg.add(this.radUseDefaultFormating);
        ret.setBorder(BorderFactory.createEtchedBorder());
        return ret;
    }

    private Component getButtonPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        this.btnOk = new JButton(s_stringMgr.getString("TableExportCsvDlg.OK"));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        ret.add((Component)this.btnOk, gbc);
        this.btnCancel = new JButton(s_stringMgr.getString("TableExportCsvDlg.Cancel"));
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0);
        ret.add((Component)this.btnCancel, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.createInfoLinkLabel(), gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        return ret;
    }

    private JLabel createInfoLinkLabel() {
        JLabel lblInfoLink = new JLabel(s_stringMgr.getString("ExportDlg.info.link.html"));
        lblInfoLink.setCursor(Cursor.getPredefinedCursor(12));
        lblInfoLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                new ExportInfoDlg((Window)ExportDlg.this);
            }
        });
        return lblInfoLink;
    }

    private Component getCommandPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        this.cboCommand = new JComboBox();
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0);
        ret.add((Component)this.cboCommand, gbc);
        LibraryResources rsrc = Main.getApplication().getResourcesFw();
        this.btnCommandFile = new JButton(rsrc.getIcon("open"));
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.btnCommandFile, gbc);
        return ret;
    }

    private Component getSeparatorPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        int padx = 0;
        int pady = 0;
        Insets labelInsets = new Insets(2, 0, 2, 5);
        Insets fieldInsets = new Insets(2, 5, 2, 0);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, labelInsets, padx, pady);
        this.lblSeparator = new JLabel(s_stringMgr.getString("TableExportCsvDlg.columnSeparator"));
        ret.add((Component)this.lblSeparator, gbc);
        this.txtSeparatorChar = new JTextField(2);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, fieldInsets, padx, pady);
        ret.add((Component)this.txtSeparatorChar, gbc);
        this.chkSeparatorTab = new JCheckBox(s_stringMgr.getString("TableExportCsvDlg.sepeartorTab"));
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, fieldInsets, padx, pady);
        ret.add((Component)this.chkSeparatorTab, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, fieldInsets, padx, pady);
        ret.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, labelInsets, padx, pady);
        this.lblLineSeparator = new JLabel(s_stringMgr.getString("TableExportCsvDlg.lineSeparatorLabel"));
        ret.add((Component)this.lblLineSeparator, gbc);
        this.cboLineSeparators = new JComboBox<Object>(new Object[]{LineSeparator.DEFAULT, LineSeparator.LF, LineSeparator.CRLF});
        gbc = new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, fieldInsets, padx, pady);
        ret.add((Component)this.cboLineSeparators, gbc);
        this.cboCharsets = new JComboBox();
        for (String s : Charset.availableCharsets().keySet()) {
            this.cboCharsets.addItem(s);
        }
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, labelInsets, padx, pady);
        this.lblCharset = new JLabel(s_stringMgr.getString("TableExportCsvDlg.charset"));
        ret.add((Component)this.lblCharset, gbc);
        gbc = new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, fieldInsets, padx, pady);
        ret.add((Component)this.cboCharsets, gbc);
        return ret;
    }

    private Component getFilePanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        this.cboFile = new JComboBox();
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0);
        ret.add((Component)this.cboFile, gbc);
        LibraryResources rsrc = Main.getApplication().getResourcesFw();
        this.btnFile = new JButton(rsrc.getIcon("open"));
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.btnFile, gbc);
        return ret;
    }
}

