/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.Window;
import java.io.File;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.DataExportCSVWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.DataExportExcelWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.DataExportJSONWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.DataExportXMLWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataInfoList;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.IExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ExportFileWriter {
    static ILogger s_log = LoggerController.createLogger(ExportFileWriter.class);
    static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExportFileWriter.class);

    public static long writeFile(IExportData data, TableExportPreferences prefs, ProgressAbortCallback progressController) {
        return ExportFileWriter.export(ExportDataInfoList.single(data), prefs, progressController, null);
    }

    public static long export(ExportDataInfoList exportDataInfoList, TableExportPreferences prefs, ProgressAbortCallback progressController, Window ownerFrame) {
        long ret = 0L;
        File file = null;
        try {
            if (prefs.isFormatXLS() || prefs.isFormatXLSOld()) {
                file = null == exportDataInfoList.getMultipleSqlResultExportDestinationInfo() ? exportDataInfoList.getSingleExportFile(prefs) : exportDataInfoList.getMultipleSqlResultExportDestinationInfo().getExcelExportFile();
                file = ExportFileWriter.checkAndPrepareExportFile(file);
                ret += new DataExportExcelWriter(file, prefs, progressController).write(exportDataInfoList);
            } else {
                for (ExportDataInfo exportDataInfo : exportDataInfoList.getExportDataInfos()) {
                    file = ExportFileWriter.checkAndPrepareExportFile(exportDataInfo.getFile(prefs));
                    if (prefs.isFormatCSV()) {
                        ret += new DataExportCSVWriter(file, prefs, progressController).write(exportDataInfo.getExportData());
                        continue;
                    }
                    if (prefs.isFormatXML()) {
                        ret += new DataExportXMLWriter(file, prefs, progressController).write(exportDataInfo.getExportData());
                        continue;
                    }
                    if (prefs.isFormatJSON()) {
                        ret += new DataExportJSONWriter(file, prefs, progressController).write(exportDataInfo.getExportData());
                        continue;
                    }
                    throw new IllegalStateException("None of the format flags is true");
                }
                if (null != progressController) {
                    progressController.setFinished();
                }
            }
            return ret;
        }
        catch (Exception e) {
            Object[] params = new Object[]{file, e.getMessage()};
            String msg = s_stringMgr.getString("TableExportCsvCommand.failedToWriteFile", params);
            s_log.error(msg, e);
            if (null != ownerFrame) {
                GUIUtils.processOnSwingEventThread(() -> JOptionPane.showMessageDialog(ownerFrame, msg), true);
            } else {
                Main.getApplication().getMessageHandler().showErrorMessage(msg);
            }
            throw new RuntimeException(e);
        }
    }

    private static File checkAndPrepareExportFile(File file) {
        file.toPath();
        if (null != file.getParentFile()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }
}

