/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.commons.lang3.StringUtils;

public class ExportInfoDlg
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExportInfoDlg.class);
    private final JLabel _lblInfo;

    public ExportInfoDlg(Window parent) {
        super(parent);
        this.setModal(true);
        this.setTitle(s_stringMgr.getString("ExportInfoDlg.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0);
        this._lblInfo = new JLabel(s_stringMgr.getString("ExportInfoDlg.info"));
        this.getContentPane().add((Component)this._lblInfo, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.getContentPane().add((Component)this.createButtonsPanel(), gbc);
        this.pack();
        GUIUtils.centerWithinParent(this);
        GUIUtils.enableCloseByEscape(this);
        this.setVisible(true);
    }

    private JPanel createButtonsPanel() {
        JPanel ret = new JPanel(new GridLayout(1, 2, 5, 5));
        JButton bntOk = new JButton(s_stringMgr.getString("ExportInfoDlg.ok"));
        bntOk.addActionListener(e -> this.close());
        ret.add(bntOk);
        JButton bntCopy = new JButton(Main.getApplication().getResources().getIcon("copy"));
        bntCopy.setToolTipText(s_stringMgr.getString("ExportInfoDlg.copy.as.text.to.clip"));
        bntCopy.addActionListener(e -> this.copyAsTextToClip());
        ret.add(bntCopy);
        return ret;
    }

    private void copyAsTextToClip() {
        String plainText = this._lblInfo.getText();
        plainText = StringUtils.replace((String)plainText, (String)"<html>", (String)"");
        plainText = StringUtils.replace((String)plainText, (String)"<br>", (String)"\n");
        plainText = StringUtils.replace((String)plainText, (String)"<pre>", (String)"");
        plainText = StringUtils.replace((String)plainText, (String)"</pre>", (String)"\n");
        plainText = StringUtils.replace((String)plainText, (String)"<ul>", (String)"");
        plainText = StringUtils.replace((String)plainText, (String)"</ul>", (String)"");
        plainText = StringUtils.replace((String)plainText, (String)"<li>", (String)"- ");
        plainText = StringUtils.replace((String)plainText, (String)"</li>", (String)"\n");
        ClipboardUtil.copyToClip(plainText);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }
}

