/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataException;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataInfoList;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportSqlNamed;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportUtil;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.JDBCResultSetExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.JTableExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.MultipleSqlResultExportDestinationInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ResultSetExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.SelectSQLInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferencesDAO;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.UITableExportData;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ExportSourceAccess {
    static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExportSourceAccess.class);
    static ILogger s_log = LoggerController.createLogger(ExportSourceAccess.class);
    private UITableExportData _uiTableExportData;
    private JDBCResultSetExportData _jdbcResultSetExportData;
    private boolean _exportMultipleResults;
    private MultipleSqlResultExportDestinationInfo _currentExportDestinationInfo;

    public ExportSourceAccess(JTable table) {
        this._uiTableExportData = new UITableExportData();
        this._uiTableExportData._tableExportDialogWasOpenedFor = table;
    }

    public ExportSourceAccess(List<SelectSQLInfo> selectSQLInfo, Connection con, DialectType dialect) {
        this._jdbcResultSetExportData = new JDBCResultSetExportData(SelectSQLInfo.toSQLs(selectSQLInfo), SelectSQLInfo.toExportSqlsNamed(selectSQLInfo), con, dialect);
    }

    public boolean isUITableMissingBlobData(String separatorChar) {
        if (this.isResultSetExport()) {
            return false;
        }
        return ExportUtil.isUITableMissingBlobData(this._uiTableExportData._tableExportDialogWasOpenedFor, separatorChar);
    }

    public ExportDataInfoList createExportData(ProgressAbortCallback progressAbortCallback) throws ExportDataException {
        if (this.isResultSetExport()) {
            return this.createResultSetExportDataInfoList(progressAbortCallback);
        }
        return this.createUiTableExportDataInfoList();
    }

    private boolean isResultSetExport() {
        return null != this._jdbcResultSetExportData;
    }

    private ExportDataInfoList createResultSetExportDataInfoList(ProgressAbortCallback progressAbortCallback) throws ExportDataException {
        if (this._jdbcResultSetExportData.getExportSqlsNamed().isEmpty()) {
            if (this._exportMultipleResults) {
                return ExportDataInfoList.EMPTY;
            }
            this.progress(progressAbortCallback, s_stringMgr.getString("ResultSetExportCommand.executingQuery.n.of.m", 1, 1));
            return ExportDataInfoList.single(this.createResultSetExportData(this._jdbcResultSetExportData.getOriginalSqlsToExport().get(0)));
        }
        ArrayList<ExportDataInfo> buf = new ArrayList<ExportDataInfo>();
        List<ExportSqlNamed> exportSqlsNamed = this._jdbcResultSetExportData.getExportSqlsNamed();
        for (int i = 0; i < exportSqlsNamed.size(); ++i) {
            this.progress(progressAbortCallback, s_stringMgr.getString("ResultSetExportCommand.executingQuery.n.of.m", i + 1, exportSqlsNamed.size()));
            ExportSqlNamed exportSqlNamed = exportSqlsNamed.get(i);
            ResultSetExportData resultSetExportData = this.createResultSetExportData(exportSqlNamed.getSql());
            buf.add(new ExportDataInfo(resultSetExportData, exportSqlNamed.getExportNameFileNormalized()));
        }
        return new ExportDataInfoList(buf, this._currentExportDestinationInfo);
    }

    private ResultSetExportData createResultSetExportData(String sql) throws ExportDataException {
        try {
            Statement stat = SQLUtilities.createStatementForStreamingResults(this._jdbcResultSetExportData.getCon(), this._jdbcResultSetExportData.getDialect());
            if (this._jdbcResultSetExportData.isLimitRows()) {
                stat.setMaxRows(this._jdbcResultSetExportData.getMaxRows());
            }
            return new ResultSetExportData(stat, sql, this._jdbcResultSetExportData.getDialect());
        }
        catch (SQLException e) {
            s_log.error(s_stringMgr.getString("ResultSetExportCommand.errorExecuteStatement"), e);
            throw new ExportDataException(s_stringMgr.getString("ResultSetExportCommand.errorExecuteStatement"), e);
        }
    }

    private ExportDataInfoList createUiTableExportDataInfoList() {
        if (this._uiTableExportData._sqlResultDataSetViewersExportDataList.isEmpty()) {
            if (this._exportMultipleResults) {
                return ExportDataInfoList.EMPTY;
            }
            return ExportDataInfoList.single(new JTableExportData(this._uiTableExportData._tableExportDialogWasOpenedFor, false == this._uiTableExportData._exportUITableSelection));
        }
        return new ExportDataInfoList(this._uiTableExportData._sqlResultDataSetViewersExportDataList, this._currentExportDestinationInfo);
    }

    public void progress(ProgressAbortCallback progressController, String task) {
        if (progressController != null) {
            progressController.currentlyLoading(task);
        }
    }

    public TableExportPreferences getPreferences() {
        TableExportPreferences prefs = TableExportPreferencesDAO.loadPreferences();
        if (this.isResultSetExport()) {
            prefs.setUseColoring(false);
        }
        return prefs;
    }

    public void prepareResultSetExport(List<ExportSqlNamed> exportSqlsNamed, boolean exportSingleFile, boolean limitRows, int maxRows, MultipleSqlResultExportDestinationInfo currentExportDestinationInfo, boolean exportMultipleResults) {
        this._jdbcResultSetExportData.setExportSingleFile(exportSingleFile);
        this._jdbcResultSetExportData.setLimitRows(limitRows);
        this._jdbcResultSetExportData.setMaxRows(maxRows);
        this._jdbcResultSetExportData.setExportSqlsNamed(exportSqlsNamed);
        this._currentExportDestinationInfo = currentExportDestinationInfo;
        this._exportMultipleResults = exportMultipleResults;
    }

    public void prepareSqlResultDataSetViewersExport(List<ExportDataInfo> sqlResultDataSetViewersExportDataList, boolean exportUITableSelection, MultipleSqlResultExportDestinationInfo currentExportDestinationInfo, boolean exportMultipleResults) {
        this._uiTableExportData._sqlResultDataSetViewersExportDataList = sqlResultDataSetViewersExportDataList;
        this._uiTableExportData._exportUITableSelection = exportUITableSelection;
        this._currentExportDestinationInfo = currentExportDestinationInfo;
        this._exportMultipleResults = exportMultipleResults;
    }

    public List<String> getOriginalSqlsToExport() {
        if (!this.isResultSetExport()) {
            throw new IllegalStateException("Not exporting SQL statement(s)!");
        }
        return this._jdbcResultSetExportData.getOriginalSqlsToExport();
    }

    public boolean hasNamedSqls() {
        if (!this.isResultSetExport()) {
            throw new IllegalStateException("Not exporting SQL statement(s)!!!");
        }
        return null != this._jdbcResultSetExportData.getExportSqlsNamed() && false == this._jdbcResultSetExportData.getExportSqlsNamed().isEmpty();
    }

    public List<ExportSqlNamed> getExportSqlsNamed() {
        return this._jdbcResultSetExportData.getExportSqlsNamed();
    }
}

