/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.io.File;
import java.text.NumberFormat;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.ClobDescriptor;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.DataExportCSVWriter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.commons.lang3.time.StopWatch;

public class ExportUtil {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExportUtil.class);

    public static boolean isUITableMissingBlobData(JTable table, String sepChar) {
        int firstSelectedColIdx = table.getSelectedColumn();
        int lastSelectedColIdx = firstSelectedColIdx + table.getSelectedColumnCount();
        int firstSelectedRowIdx = table.getSelectedRow();
        int lastSelectedRowIdx = firstSelectedRowIdx + table.getSelectedRowCount();
        for (int colIdx = table.getSelectedColumn(); colIdx < lastSelectedColIdx; ++colIdx) {
            ExtTableColumn col;
            int sqlType;
            if (!(table.getColumnModel().getColumn(colIdx) instanceof ExtTableColumn) || (sqlType = (col = (ExtTableColumn)table.getColumnModel().getColumn(colIdx)).getColumnDisplayDefinition().getSqlType()) != 2005) continue;
            for (int rowIdx = firstSelectedRowIdx; rowIdx < lastSelectedRowIdx; ++rowIdx) {
                Object cellObj = table.getValueAt(rowIdx, colIdx);
                String data = DataExportCSVWriter.getDataCSV(sepChar, "" + cellObj);
                if (!ClobDescriptor.i18n.CLOB_LABEL.equals(data)) continue;
                return true;
            }
        }
        return false;
    }

    public static String createDefaultExportName(int index) {
        return "Squirrel SQL Export " + index;
    }

    public static void writeExportMessage(StopWatch stopWatch, long writtenRows, File targetFile) {
        NumberFormat nf = NumberFormat.getIntegerInstance();
        String rows = nf.format(writtenRows);
        String seconds = nf.format(stopWatch.getTime() / 1000L);
        ExportUtil.writeExportMessage(rows, targetFile, seconds);
    }

    public static void writeExportMessage(String rows, File targetFile, String seconds) {
        String msg = s_stringMgr.getString("CreateFileOfCurrentSQLCommand.progress.successMessage", rows, targetFile, seconds);
        Main.getApplication().getMessageHandler().showMessage(msg);
    }
}

