/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.ClobDescriptor;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportControllerProxy;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataException;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataInfoList;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportFileWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExporterCallback;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferencesDAO;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.util.DesktopUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class Exporter {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(Exporter.class);
    private static ILogger s_log = LoggerController.createLogger(Exporter.class);
    private final ExportControllerProxy _exportControllerProxy;
    private ProgressAbortCallback _progressController = null;
    private File _singleExportTargetFile;
    private long writtenRows = -1L;
    private ExporterCallback _exporterCallback;

    public Exporter(ExporterCallback exporterCallback, ExportControllerProxy exportControllerProxy) {
        this._exporterCallback = exporterCallback;
        this._exportControllerProxy = exportControllerProxy;
    }

    public void export() {
        this.exportDialogClosed(this._exportControllerProxy);
    }

    private void exportDialogClosed(ExportControllerProxy ctrl) {
        try {
            int choice;
            if (!ctrl.isOK()) {
                return;
            }
            if (ctrl.isUITableMissingBlobData() && (choice = JOptionPane.showConfirmDialog(ctrl.getOwningWindow(), s_stringMgr.getString("TableExportCsvCommand.missingClobDataMsg", ClobDescriptor.i18n.CLOB_LABEL))) != 0) {
                return;
            }
            this._singleExportTargetFile = ctrl.getSingleExportTargetFile();
            this.export(ctrl);
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private void export(ExportControllerProxy ctrl) throws ExportDataException {
        File firstExportedFile;
        this._progressController = this._exporterCallback.createProgressController();
        int numberOfFilesExported = 1;
        try {
            ExportDataInfoList exportDataInfoList = ctrl.createExportData(this._progressController);
            if (exportDataInfoList.isEmpty()) {
                if (null != this._progressController) {
                    this._progressController.setFinished();
                }
                Runnable runnable = () -> JOptionPane.showMessageDialog(ctrl.getOwningWindow(), s_stringMgr.getString("Exporter.no.files.to.export"), s_stringMgr.getString("Exporter.no.files.to.export.title"), 2);
                GUIUtils.processOnSwingEventThread(runnable);
                return;
            }
            this.writtenRows = this.writeExport(ctrl, exportDataInfoList);
            TableExportPreferences prefs = TableExportPreferencesDAO.loadPreferences();
            firstExportedFile = exportDataInfoList.getFirstExportFile(prefs);
            if (prefs.isExportMultipleSQLResults() && !prefs.isFormatXLS() && !prefs.isFormatXLSOld()) {
                numberOfFilesExported = exportDataInfoList.getExportDataInfos().size();
            }
        }
        catch (Exception e) {
            Runnable runnable = () -> JOptionPane.showMessageDialog(ctrl.getOwningWindow(), s_stringMgr.getString("AbstractExportCommand.failed.new"));
            GUIUtils.processOnSwingEventThread(runnable);
            if (null != this._progressController) {
                try {
                    this._progressController.setVisible(false);
                    this._progressController.dispose();
                }
                catch (Exception ex) {
                    s_log.error("Failed to close progress display.", e);
                }
            }
            throw e;
        }
        if (this.writtenRows >= 0L) {
            String command = ctrl.getCommand(firstExportedFile);
            if (null != command) {
                this.executeOpenExportedFileCommand(command, ctrl.getOwningWindow());
            } else {
                int finalNumberOfFilesExported = numberOfFilesExported;
                GUIUtils.processOnSwingEventThread(() -> this.showExportSuccessMessage(ctrl.getOwningWindow(), this.writtenRows, firstExportedFile, finalNumberOfFilesExported, ctrl.isShowExportCompleteAsDialog()), true);
            }
        } else {
            s_log.info("Probably failed to export the result of the SQL Select statement into a file. No rows were written.");
            String noRowsMessage = s_stringMgr.getString("AbstractExportCommand.failed.no.rows.written");
            if (ctrl.isShowExportCompleteAsDialog()) {
                Runnable runnable = () -> JOptionPane.showMessageDialog(ctrl.getOwningWindow(), noRowsMessage);
                GUIUtils.processOnSwingEventThread(runnable, true);
            } else {
                Main.getApplication().getMessageHandler().showWarningMessage(noRowsMessage);
            }
        }
    }

    private long writeExport(ExportControllerProxy ctrl, ExportDataInfoList exportDataInfoList) {
        return ExportFileWriter.export(exportDataInfoList, ctrl.getPreferences(), this._progressController, ctrl.getOwningWindow());
    }

    private void executeOpenExportedFileCommand(String command, final Window owner) {
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            Object[] params = new Object[]{command, e.getMessage()};
            final String msg = s_stringMgr.getString("TableExportCsvCommand.failedToExecuteCommand", params);
            s_log.error(msg, e);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(owner, msg);
                }
            };
            GUIUtils.processOnSwingEventThread(runnable, true);
        }
    }

    private void showExportSuccessMessage(Window owner, long writtenRows, File exportFile, int numberOfFilesExported, boolean showExportSuccessAsDialog) {
        String formattedWrittenRows = NumberFormat.getIntegerInstance().format(writtenRows);
        String fileName = StringUtilities.shortenBegin(exportFile.getAbsolutePath(), 300, "...");
        String exportSuccessMessage = 1 < numberOfFilesExported ? s_stringMgr.getString("TableExportCsvCommand.writeFileSuccess.multiple.files", formattedWrittenRows, fileName, numberOfFilesExported - 1) : s_stringMgr.getString("TableExportCsvCommand.writeFileSuccess", formattedWrittenRows, fileName);
        if (!showExportSuccessAsDialog) {
            Main.getApplication().getMessageHandler().showMessage(exportSuccessMessage);
            return;
        }
        Object[] selectionValues = new String[]{s_stringMgr.getString("TableExportCsvCommand.export.completed.ok"), s_stringMgr.getString("TableExportCsvCommand.export.completed.ok.show.in.file.manager")};
        int selectIndex = JOptionPane.showOptionDialog(owner, exportSuccessMessage, s_stringMgr.getString("TableExportCsvCommand.writeFileSuccess.title"), -1, 1, null, selectionValues, selectionValues[0]);
        if (selectIndex == 1) {
            DesktopUtil.openInFileManager(exportFile);
        }
    }

    public void progress(String task) {
        if (this._progressController != null) {
            this._progressController.currentlyLoading(task);
        }
    }

    public File getSingleExportTargetFile() {
        return this._singleExportTargetFile;
    }

    public long getWrittenRows() {
        return this.writtenRows;
    }
}

