/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import org.apache.commons.lang3.StringUtils;

public enum FileEndings {
    CSV("csv"),
    XLSX("xlsx"),
    XLS("xls"),
    XML("xml"),
    JSON("json");

    private String _ending;

    private FileEndings(String ending) {
        this._ending = ending;
    }

    public static boolean fileEndsWithOneOf(String fileNameToTest) {
        if (StringUtilities.isEmpty(fileNameToTest, true)) {
            return false;
        }
        for (FileEndings fileEnding : FileEndings.values()) {
            if (!fileEnding.fileEndsWith(fileNameToTest)) continue;
            return true;
        }
        return false;
    }

    public boolean fileEndsWith(String fileNameToTest) {
        return StringUtils.endsWithIgnoreCase((CharSequence)fileNameToTest, (CharSequence)("." + this._ending));
    }

    public static String getByTableExportPreferences(TableExportPreferences prefs) {
        if (prefs.isFormatCSV()) {
            return CSV.get();
        }
        if (prefs.isFormatJSON()) {
            return JSON.get();
        }
        if (prefs.isFormatXML()) {
            return XML.get();
        }
        if (prefs.isFormatXLS()) {
            return XLSX.get();
        }
        if (prefs.isFormatXLSOld()) {
            return XLS.get();
        }
        throw new IllegalStateException("Could not find file ending by TableExportPreferences");
    }

    public String get() {
        return this._ending;
    }
}

