/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfigFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.DisplayReachedCallBack;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportFileProvider;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ProgressAbortDialog;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class FileExportProgressManager {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FileExportProgressManager.class);
    private final ISession _session;
    private final String _sqlsJoined;
    private final ExportFileProvider _exportFileProvider;
    private ProgressAbortDialog progressDialog;

    public FileExportProgressManager(ISession session, String sqlsJoined, ExportFileProvider exportFileProvider) {
        this._session = session;
        this._sqlsJoined = sqlsJoined;
        this._exportFileProvider = exportFileProvider;
    }

    public ProgressAbortCallback getOrCreateProgressCallback() {
        return this.getOrCreateProgressCallback(null);
    }

    public ProgressAbortCallback getOrCreateProgressCallback(DisplayReachedCallBack displayReachedCallBack) {
        if (null == this.progressDialog) {
            this.createProgressAbortDialog(displayReachedCallBack);
        }
        return this.progressDialog;
    }

    private void createProgressAbortDialog(DisplayReachedCallBack displayReachedCallBack) {
        GUIUtils.processOnSwingEventThread(() -> this.showProgressDialog(displayReachedCallBack), true);
    }

    private void showProgressDialog(DisplayReachedCallBack displayReachedCallBack) {
        CodeReformator cr = new CodeReformator(CodeReformatorConfigFactory.createConfig(this._session));
        String reformatedSQL = cr.reformat(this._sqlsJoined);
        String targetFile = this._exportFileProvider.getExportFile().getAbsolutePath();
        String title = s_stringMgr.getString("CreateFileOfCurrentSQLCommand.progress.title", targetFile);
        this.progressDialog = new ProgressAbortDialog(Main.getApplication().getMainFrame(), title, targetFile, reformatedSQL, 0, () -> this.onCancel(), displayReachedCallBack);
        this.progressDialog.setVisible(true);
    }

    private void onCancel() {
        Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("FileExportProgressManager.file.export.user.canceled"));
    }

    public void hideProgressMonitor() {
        if (this.progressDialog != null) {
            this.progressDialog.setVisible(false);
            this.progressDialog.dispose();
        }
    }

    public boolean isAborted() {
        return this.progressDialog != null && this.progressDialog.isUserCanceled();
    }
}

