/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.concurrent.TimeUnit;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;

public class FileExportService {
    private static final int FEEDBACK_EVRY_N_SECONDS = 2;
    private File _file;
    private TableExportPreferences _prefs;
    private final ProgressAbortCallback _progressController;
    private long timeOfLastStatusUpdate = 0L;

    public FileExportService(File file, TableExportPreferences prefs, ProgressAbortCallback progressController) {
        this._file = file;
        this._prefs = prefs;
        this._progressController = progressController;
    }

    public File getFile() {
        return this._file;
    }

    public TableExportPreferences getPrefs() {
        return this._prefs;
    }

    public void setProgressFinished() {
        if (this._progressController != null) {
            this._progressController.setFinished();
        }
    }

    public boolean isStatusUpdateNecessary() {
        long time = System.currentTimeMillis();
        if (this.timeOfLastStatusUpdate + TimeUnit.SECONDS.toMillis(2L) < time) {
            this.timeOfLastStatusUpdate = time;
            return true;
        }
        return false;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public void setPrefs(TableExportPreferences prefs) {
        this._prefs = prefs;
    }

    public void progress(String task) {
        if (this._progressController != null) {
            this._progressController.currentlyLoading(task);
        }
    }

    public void taskStatus(String status) {
        if (this._progressController != null) {
            this._progressController.setTaskStatus(status);
        }
    }

    public boolean isUserCanceled() {
        if (this._progressController == null) {
            return false;
        }
        return this._progressController.isUserCanceled();
    }

    public Charset getCharset() {
        try {
            return Charset.forName(this.getPrefs().getEncoding());
        }
        catch (IllegalCharsetNameException icne) {
            return Charset.defaultCharset();
        }
    }
}

