/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportCellData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataRow;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.IExportData;

public class JTableExportData
implements IExportData {
    private JTable _table;
    private int _nbrSelRows;
    private int _nbrSelCols;
    private int[] _selRows;
    private int[] _selcols;

    public JTableExportData(JTable table, boolean complete) {
        int i;
        this._table = table;
        this._nbrSelRows = table.getSelectedRowCount();
        if (0 == this._nbrSelRows || complete) {
            this._nbrSelRows = table.getRowCount();
        }
        this._nbrSelCols = table.getSelectedColumnCount();
        if (0 == this._nbrSelCols || complete) {
            this._nbrSelCols = table.getColumnCount();
        }
        this._selRows = table.getSelectedRows();
        if (0 == this._selRows.length || complete) {
            this._selRows = new int[this._nbrSelRows];
            for (i = 0; i < this._selRows.length; ++i) {
                this._selRows[i] = i;
            }
        }
        this._selcols = table.getSelectedColumns();
        if (0 == this._selcols.length || complete) {
            this._selcols = new int[this._nbrSelCols];
            for (i = 0; i < this._selcols.length; ++i) {
                this._selcols[i] = i;
            }
        }
    }

    @Override
    public Iterator<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        for (int colIdx = 0; colIdx < this._nbrSelCols; ++colIdx) {
            String columnName = this._table.getColumnName(this._selcols[colIdx]);
            headers.add(columnName);
        }
        return headers.iterator();
    }

    @Override
    public Iterator<ExportDataRow> getRows() {
        ArrayList<ExportDataRow> rows = new ArrayList<ExportDataRow>(this._nbrSelRows);
        for (int rowIdx = 0; rowIdx < this._nbrSelRows; ++rowIdx) {
            ArrayList<ExportCellData> cells = new ArrayList<ExportCellData>(this._nbrSelCols);
            for (int colIdx = 0; colIdx < this._nbrSelCols; ++colIdx) {
                ExportCellData cellObj;
                Object obj = this._table.getValueAt(this._selRows[rowIdx], this._selcols[colIdx]);
                if (this._table.getColumnModel().getColumn(colIdx) instanceof ExtTableColumn) {
                    ExtTableColumn col = (ExtTableColumn)this._table.getColumnModel().getColumn(this._selcols[colIdx]);
                    cellObj = new ExportCellData(col.getColumnDisplayDefinition(), obj, rowIdx, colIdx);
                } else {
                    cellObj = new ExportCellData(null, obj, rowIdx, colIdx);
                }
                if (this._table instanceof DataSetViewerTable) {
                    Color excelExportColor = ((DataSetViewerTable)this._table).getColoringService().getExcelExportRelevantColor(rowIdx, colIdx, obj);
                    cellObj.setExcelExportColor(excelExportColor);
                }
                cells.add(cellObj);
            }
            rows.add(new ExportDataRow(cells, rowIdx));
        }
        return rows.iterator();
    }

    @Override
    public void close() {
    }
}

