/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.MsExcelSheet;

public class MsExcelWorkbook {
    private final String _workbookFileName;
    private List<MsExcelSheet> _sheets = new ArrayList<MsExcelSheet>();

    public MsExcelWorkbook(String workbookFileName) {
        this._workbookFileName = workbookFileName;
    }

    public void addSheet(String sheetName, String sheetSql) {
        this._sheets.add(new MsExcelSheet(sheetName, sheetSql));
    }

    public boolean hasSheets() {
        return 0 < this._sheets.size();
    }

    public String getWorkbookFileName() {
        return this._workbookFileName;
    }

    public List<MsExcelSheet> getSheets() {
        return this._sheets;
    }

    public File getWorkbookFile() {
        return new File(this._workbookFileName);
    }

    public List<String> getSqlList() {
        return this._sheets.stream().map(s -> s.getSheetSql()).collect(Collectors.toList());
    }
}

