/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.MsExcelWorkbook;

public class MsExcelWorkbookList {
    private List<MsExcelWorkbook> _workbooks = new ArrayList<MsExcelWorkbook>();

    public void addCurrentWorkbook(String workbookFileName) {
        this._workbooks.add(new MsExcelWorkbook(workbookFileName));
    }

    public void addSheetToCurrentWorkbook(String sheetName, String sheetSql) {
        if (this._workbooks.isEmpty()) {
            throw new IllegalStateException("Need a workbook before sheets can be added");
        }
        this._workbooks.get(this._workbooks.size() - 1).addSheet(sheetName, sheetSql);
    }

    public boolean hasExportReadyWorkbook() {
        return this._workbooks.size() > 1;
    }

    public MsExcelWorkbook checkoutExportReadyWorkbook() {
        if (!this.hasExportReadyWorkbook()) {
            throw new IllegalStateException("Has no export ready workbook");
        }
        return this._workbooks.get(this._workbooks.size() - 2);
    }

    public MsExcelWorkbook checkoutCurrentWorkbook() {
        MsExcelWorkbook ret = this._workbooks.get(this._workbooks.size() - 1);
        if (ret.hasSheets()) {
            return ret;
        }
        return null;
    }
}

