/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLResultExecutorPanel;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.SqlResultTabHandle;

public class MultipleSqlResultExportChannel {
    public List<SqlResultTabHandle> getSqlResultTabHandles() {
        ISession activeSession = Main.getApplication().getSessionManager().getActiveSession();
        if (null == activeSession) {
            return Collections.emptyList();
        }
        ISQLPanelAPI sqlPanelApi = activeSession.getSQLPanelAPIOfActiveSessionWindow(true);
        if (null == sqlPanelApi) {
            return Collections.emptyList();
        }
        List<IResultTab> tabs = sqlPanelApi.getSQLResultExecuter().getAllSqlResultTabs();
        return tabs.stream().map(t -> MultipleSqlResultExportChannel.createSqlResultTabHandle(sqlPanelApi, (ResultTab)t)).collect(Collectors.toList());
    }

    private static SqlResultTabHandle createSqlResultTabHandle(ISQLPanelAPI sqlPanelApi, ResultTab t) {
        return new SqlResultTabHandle(t, (SQLResultExecutorPanel)sqlPanelApi.getSQLResultExecuter());
    }
}

