/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.DisplayReachedCallBack;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TaskDescriptionComponent;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.UserCancelRequestListener;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.StringUtils;

public class ProgressAbortDialog
extends JDialog
implements ProgressAbortCallback {
    private static final ILogger s_log = LoggerController.createLogger(ProgressAbortDialog.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ProgressAbortDialog.class);
    private TaskDescriptionComponent taskDescription;
    private String _targetFile = s_stringMgr.getString("ProgressAbortDialog.targetFile.not.applicable");
    private String _sql = s_stringMgr.getString("ProgressAbortDialog.sql.not.applicable");
    private DateFormat dateFormat = DateFormat.getTimeInstance();
    private int itemCount = 0;
    private JProgressBar progressBar = null;
    private JLabel statusLabel = null;
    private JLabel additionalStatusLabel = null;
    private String _loadingPrefix = s_stringMgr.getString("ProgressAbortDialog.defaultLoadingPrefix");
    private boolean indeterminate;
    private UserCancelRequestListener _userCancelRequestListener;
    private JButton cancelButton;
    private JTextArea historyArea;
    private JComponent taskDescriptionComponent;
    private boolean canceled;
    private boolean finished;

    public ProgressAbortDialog(Window owningFrame, String title, UserCancelRequestListener userCancelRequestListener) {
        this(owningFrame, title, null, null, 0, userCancelRequestListener, null);
    }

    public ProgressAbortDialog(Window owningFrame, String title, String targetFile, String sql, int totalItems, UserCancelRequestListener userCancelRequestListener, final DisplayReachedCallBack displayReachedCallBack) {
        super(owningFrame, title);
        this.setLocationRelativeTo(owningFrame);
        this.init(title, totalItems, userCancelRequestListener);
        if (null != targetFile) {
            this._targetFile = targetFile;
        }
        if (null != sql) {
            this._sql = sql;
        }
        this.setLabelValues();
        if (null != displayReachedCallBack) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    displayReachedCallBack.dialogIsDisplaying();
                }
            });
        }
    }

    @Override
    public void setTotalItems(int totalItems) {
        this.itemCount = totalItems;
        this.progressBar.setMaximum(totalItems);
    }

    @Override
    public void setLoadingPrefix(String loadingPrefix) {
        if (loadingPrefix != null) {
            this._loadingPrefix = loadingPrefix;
        }
    }

    @Override
    public void currentlyLoading(String simpleName) {
        final StringBuilder statusText = this.appendPrefixed(simpleName);
        try {
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    ProgressAbortDialog.this.statusLabel.setText(statusText.toString());
                    ProgressAbortDialog.this.setTaskStatus(null);
                    ProgressAbortDialog.this.progressBar.setValue(ProgressAbortDialog.this.progressBar.getValue() + 1);
                    if (ProgressAbortDialog.this.finishedLoading()) {
                        ProgressAbortDialog.this.setVisible(false);
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            s_log.error("Unexpected exception: " + e.getMessage(), e);
        }
    }

    private StringBuilder appendPrefixed(String simpleName) {
        StringBuilder statusText = new StringBuilder();
        statusText.append(this._loadingPrefix);
        statusText.append(" ");
        statusText.append(simpleName);
        this.appendToHistory(statusText.toString());
        return statusText;
    }

    @Override
    public void setTaskStatus(String status) {
        final StringBuilder statusText = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)status)) {
            statusText.append(status);
        } else {
            statusText.append(" ");
        }
        try {
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    String statusTextToAppend = statusText.toString();
                    ProgressAbortDialog.this.additionalStatusLabel.setText(statusTextToAppend);
                    if (StringUtils.isNotBlank((CharSequence)statusTextToAppend)) {
                        ProgressAbortDialog.this.appendPrefixed(statusTextToAppend);
                    }
                }
            });
        }
        catch (Exception e) {
            s_log.error("Unexpected exception: " + e.getMessage(), e);
        }
    }

    private void appendToHistory(String string) {
        if (this.historyArea != null) {
            final StringBuilder sb = new StringBuilder();
            sb.append(this.dateFormat.format(new Date()));
            sb.append(": ");
            sb.append(string);
            sb.append(StringUtilities.getEolStr());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressAbortDialog.this.historyArea.append(sb.toString());
                    ProgressAbortDialog.this.historyArea.setCaretPosition(ProgressAbortDialog.this.historyArea.getDocument().getLength());
                }
            };
            GUIUtils.processOnSwingEventThread(runnable);
        }
    }

    @Override
    public boolean finishedLoading() {
        if (this.finished) {
            this.progressBar.setIndeterminate(false);
            return true;
        }
        if (this.indeterminate) {
            return false;
        }
        return this.progressBar.getValue() == this.itemCount;
    }

    @Override
    public void dispose() {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                ProgressAbortDialog.this.callDisposeFromSuperClass();
            }
        });
    }

    private void callDisposeFromSuperClass() {
        super.dispose();
    }

    @Override
    public void setVisible(boolean b) {
        GUIUtils.processOnSwingEventThread(() -> this.callSetVisibleFromSuperClass(b));
    }

    private void callSetVisibleFromSuperClass(boolean b) {
        super.setVisible(b);
    }

    private void init(String description, int totalItems, UserCancelRequestListener abortHandler) {
        this.itemCount = totalItems;
        this.indeterminate = totalItems <= 0;
        this._userCancelRequestListener = abortHandler;
        Window owner = super.getOwner();
        this.createGUI();
        this.setLocationRelativeTo(owner);
    }

    private void createGUI() {
        JPanel dialogPanel = new JPanel(new GridBagLayout());
        dialogPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.anchor = 17;
        c.insets = new Insets(4, 0, 4, 0);
        this.taskDescriptionComponent = this.createTaskDescription();
        dialogPanel.add((Component)this.taskDescriptionComponent, c);
        ++c.gridy;
        JPanel progressPanel = new JPanel(new GridBagLayout());
        progressPanel.setMinimumSize(new Dimension(400, 200));
        progressPanel.setPreferredSize(new Dimension(400, 200));
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        dialogPanel.add((Component)progressPanel, c);
        c.gridy = 0;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(4, 10, 4, 10);
        this.statusLabel = new JLabel(s_stringMgr.getString("ProgressAbortDialog.initialLoadingPrefix"));
        progressPanel.add((Component)this.statusLabel, c);
        ++c.gridy;
        c.insets = new Insets(4, 10, 4, 10);
        this.additionalStatusLabel = new JLabel(" ");
        progressPanel.add((Component)this.additionalStatusLabel, c);
        ++c.gridy;
        c.weightx = 1.0;
        this.progressBar = new JProgressBar(0, this.itemCount);
        this.progressBar.setIndeterminate(this.indeterminate);
        progressPanel.add((Component)this.progressBar, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.historyArea = new JTextArea();
        this.historyArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.historyArea);
        progressPanel.add((Component)jScrollPane, c);
        if (this._userCancelRequestListener != null) {
            this.cancelButton = new JButton(new CancelAction());
            ++c.gridy;
            c.anchor = 17;
            c.fill = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            dialogPanel.add((Component)this.cancelButton, c);
        }
        super.getContentPane().add(dialogPanel);
        super.pack();
        super.setSize(new Dimension(450, 450));
        super.setDefaultCloseOperation(0);
        super.addWindowListener(new WindowCloseListener());
    }

    private void setLabelValues() {
        this.taskDescription.setTargetFile(this.getTargetFile());
        this.taskDescription.setSql(this.getSql());
    }

    private JComponent createTaskDescription() {
        this.taskDescription = new TaskDescriptionComponent(this.getTargetFile(), this.getSql());
        return this.taskDescription;
    }

    public void closeProgressDialog() {
        GUIUtils.processOnSwingEventThread(() -> this._close());
    }

    private void _close() {
        this.setVisible(false);
        this.dispose();
    }

    public String getTargetFile() {
        return this._targetFile;
    }

    public void setTargetFile(String targetFile) {
        this._targetFile = targetFile;
        GUIUtils.processOnSwingEventThread(() -> this.setLabelValues());
    }

    public String getSql() {
        return this._sql;
    }

    public void setSql(String sql) {
        this._sql = sql;
        GUIUtils.processOnSwingEventThread(() -> this.setLabelValues());
    }

    @Override
    public boolean isUserCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    @Override
    public void setFinished() {
        this.finished = true;
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(s_stringMgr.getString("ProgressAbortDialog.cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.clickCancel();
        }

        public void clickCancel() {
            int ret = JOptionPane.showConfirmDialog(ProgressAbortDialog.this, s_stringMgr.getString("ProgressAbortDialog.confirmCancel"));
            if (0 == ret) {
                ProgressAbortDialog.this.appendToHistory(s_stringMgr.getString("ProgressAbortDialog.cancelFeedback"));
                ProgressAbortDialog.this.canceled = true;
                ProgressAbortDialog.this.cancelButton.setEnabled(false);
                ProgressAbortDialog.this._userCancelRequestListener.cancelButtonClicked();
            }
        }
    }

    private class WindowCloseListener
    extends WindowAdapter {
        private WindowCloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            new CancelAction().clickCancel();
        }
    }
}

