/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.Window;
import java.io.File;
import java.sql.Connection;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportController;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportControllerProxy;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDialogType;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportSourceAccess;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.Exporter;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExporterCallback;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.FileExportProgressManager;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.SelectSQLInfo;

public class ResultSetExport {
    private final Exporter _exporter;

    public ResultSetExport(Connection con, List<SelectSQLInfo> selectSQLInfos, DialectType dialect, FileExportProgressManager fileExportProgressManager, Window owner) {
        ExporterCallback exporterCallback = () -> fileExportProgressManager.getOrCreateProgressCallback();
        ExportController[] exportControllerRef = new ExportController[1];
        GUIUtils.processOnSwingEventThread(() -> {
            exportControllerRef[0] = new ExportController(new ExportSourceAccess(selectSQLInfos, con, dialect), owner, ExportDialogType.RESULT_SET_EXPORT);
            exportControllerRef[0].showDialog();
        }, true);
        this._exporter = new Exporter(exporterCallback, new ExportControllerProxy(exportControllerRef[0]));
    }

    public void export() {
        this._exporter.export();
    }

    public File getTargetFile() {
        return this._exporter.getSingleExportTargetFile();
    }

    public long getWrittenRows() {
        return this._exporter.getWrittenRows();
    }
}

