/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportCellData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataRow;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.IExportData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetExportData
implements IExportData {
    private static final ILogger log = LoggerController.createLogger(ResultSetExportData.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultSetExportData.class);
    private Statement _stat;
    private ResultSet _resultSet;
    private List<ColumnDisplayDefinition> _colDispDef;
    private DialectType _dialect;
    private int rowIndex = 0;

    public ResultSetExportData(Statement stat, String sqlToWriteToFile, DialectType dialect) throws SQLException {
        this._stat = stat;
        this._resultSet = stat.executeQuery(sqlToWriteToFile);
        this._colDispDef = new ArrayList<ColumnDisplayDefinition>();
        this._dialect = dialect;
        int columnCount = this._resultSet.getMetaData().getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            this._colDispDef.add(new ColumnDisplayDefinition(this._resultSet, i, this._dialect, true));
        }
    }

    @Override
    public Iterator<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        for (ColumnDisplayDefinition col : this._colDispDef) {
            String headerValue = col.getColumnHeading();
            headers.add(headerValue);
        }
        return headers.iterator();
    }

    @Override
    public Iterator<ExportDataRow> getRows() {
        return new Iterator<ExportDataRow>(){

            @Override
            public void remove() {
                throw new IllegalStateException("not supported");
            }

            @Override
            public ExportDataRow next() {
                return ResultSetExportData.this.createRow();
            }

            @Override
            public boolean hasNext() {
                return ResultSetExportData.this.hasNextRow();
            }
        };
    }

    @Override
    public void close() {
        SQLUtilities.closeResultSet(this._resultSet);
        SQLUtilities.closeStatement(this._stat);
    }

    private boolean hasNextRow() {
        try {
            return this._resultSet.next();
        }
        catch (SQLException e) {
            log.error(s_stringMgr.getString("ResultSetExportData.errorReadingResultSet"), e);
            throw new RuntimeException(s_stringMgr.getString("ResultSetExportData.errorReadingResultSet"), e);
        }
    }

    private ExportDataRow createRow() {
        try {
            ArrayList<ExportCellData> cells = new ArrayList<ExportCellData>();
            for (int i = 1; i <= this._colDispDef.size(); ++i) {
                ColumnDisplayDefinition colDef = this._colDispDef.get(i - 1);
                Object object = CellComponentFactory.readResultSet(colDef, this._resultSet, i, false);
                ExportCellData cell = new ExportCellData(colDef, object, this.rowIndex, i - 1);
                cells.add(cell);
            }
            ExportDataRow data = new ExportDataRow(cells, this.rowIndex);
            ++this.rowIndex;
            return data;
        }
        catch (SQLException e) {
            log.error(s_stringMgr.getString("ResultSetExportData.errorReadingResultSet"), e);
            throw new RuntimeException(s_stringMgr.getString("ResultSetExportData.errorReadingResultSet"), e);
        }
    }
}

