/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDialogType;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.SqlResultListEntry;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.SmallToolTipInfoButton;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TableExportSelectionPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableExportSelectionPanel.class);
    JRadioButton radCompleteTableOrSingleFile;
    JRadioButton radSelectionInUiTable;
    JCheckBox chkLimitRows;
    IntegerField txtLimitRows;
    JRadioButton radMultipleSQLRes;
    JList<SqlResultListEntry> lstSQLResultsToExport;
    JButton btnUp;
    JButton btnDown;
    JButton btnEdit;
    JButton btnDelete;
    JButton btnSaveNames;
    JButton btnApplySavedNames;
    JTextField txtExportFileOrDir;
    SmallToolTipInfoButton btnInfo;

    public TableExportSelectionPanel(ExportDialogType exportDialogType) {
        super(new GridBagLayout());
        JPanel pnlButtons;
        if (exportDialogType == ExportDialogType.UI_TABLE_EXPORT) {
            pnlButtons = this.createButtonPanelForUiTableExport();
        } else if (exportDialogType == ExportDialogType.RESULT_SET_EXPORT) {
            pnlButtons = this.createButtonPanelForResultSetExport();
        } else {
            throw new IllegalArgumentException("Unknown exportDialogType: " + exportDialogType);
        }
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0);
        this.add((Component)pnlButtons, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0);
        this.add((Component)this.createSQLResultExportListPanel(), gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.radCompleteTableOrSingleFile);
        if (exportDialogType == ExportDialogType.UI_TABLE_EXPORT) {
            bg.add(this.radSelectionInUiTable);
        }
        bg.add(this.radMultipleSQLRes);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    private JPanel createButtonPanelForResultSetExport() {
        JPanel ret = new JPanel(new GridBagLayout());
        this.radCompleteTableOrSingleFile = new JRadioButton(s_stringMgr.getString("TableExportCsvDlg.export.single.file"));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0);
        ret.add((Component)this.radCompleteTableOrSingleFile, gbc);
        this.radMultipleSQLRes = new JRadioButton(s_stringMgr.getString("TableExportCsvDlg.exportMultipleSQLResults"));
        this.radMultipleSQLRes.setToolTipText(s_stringMgr.getString("TableExportCsvDlg.exportMultipleSQLResults.tooltip"));
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0);
        ret.add((Component)this.radMultipleSQLRes, gbc);
        JPanel pnlLimit = new JPanel(new GridLayout(1, 2, 5, 5));
        this.chkLimitRows = new JCheckBox(s_stringMgr.getString("ResultSetExportDialog.limitRows"));
        pnlLimit.add(this.chkLimitRows);
        this.txtLimitRows = new IntegerField(5);
        pnlLimit.add(this.txtLimitRows);
        gbc = new GridBagConstraints(1, 0, 1, 0, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)pnlLimit, gbc);
        return ret;
    }

    private JPanel createButtonPanelForUiTableExport() {
        JPanel ret = new JPanel(new GridBagLayout());
        this.radCompleteTableOrSingleFile = new JRadioButton(s_stringMgr.getString("TableExportCsvDlg.exportCompleteTable"));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        ret.add((Component)this.radCompleteTableOrSingleFile, gbc);
        this.radSelectionInUiTable = new JRadioButton(s_stringMgr.getString("TableExportCsvDlg.exportSelection"));
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.radSelectionInUiTable, gbc);
        this.radMultipleSQLRes = new JRadioButton(s_stringMgr.getString("TableExportCsvDlg.exportMultipleSQLResults"));
        this.radMultipleSQLRes.setToolTipText(s_stringMgr.getString("TableExportCsvDlg.exportMultipleSQLResults.tooltip"));
        gbc = new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0);
        ret.add((Component)this.radMultipleSQLRes, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 0, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        return ret;
    }

    private JPanel createSQLResultExportListPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.lstSQLResultsToExport = new JList();
        this.lstSQLResultsToExport.setSelectionMode(0);
        ret.add((Component)new JScrollPane(this.lstSQLResultsToExport), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.createRightSideListEditButtons(), gbc);
        gbc = new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0);
        this.txtExportFileOrDir = GUIUtils.styleTextFieldToCopyableLabel(new JTextField());
        ret.add((Component)this.txtExportFileOrDir, gbc);
        return GUIUtils.setPreferredHeight(ret, 200);
    }

    private JPanel createRightSideListEditButtons() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.btnUp = new JButton(Main.getApplication().getResources().getIcon("prev_nav"));
        this.btnUp.setToolTipText(s_stringMgr.getString("TableExportSelectionPanel.edit.excel.table_sheet.order.tooltip"));
        ret.add((Component)GUIUtils.styleAsToolbarButton(this.btnUp), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.btnDown = new JButton(Main.getApplication().getResources().getIcon("next_nav"));
        this.btnDown.setToolTipText(s_stringMgr.getString("TableExportSelectionPanel.edit.excel.table_sheet.order.tooltip"));
        ret.add((Component)GUIUtils.styleAsToolbarButton(this.btnDown), gbc);
        gbc = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0);
        this.btnEdit = new JButton(Main.getApplication().getResources().getIcon("edit"));
        this.btnEdit.setToolTipText(s_stringMgr.getString("TableExportSelectionPanel.edit.excel.table_sheet.name.tooltip"));
        ret.add((Component)GUIUtils.styleAsToolbarButton(this.btnEdit), gbc);
        gbc = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0);
        this.btnDelete = new JButton(Main.getApplication().getResources().getIcon("delete"));
        this.btnDelete.setToolTipText(s_stringMgr.getString("TableExportSelectionPanel.remove.sql.result.tooltip"));
        ret.add((Component)GUIUtils.styleAsToolbarButton(this.btnDelete), gbc);
        gbc = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0);
        this.btnSaveNames = new JButton(Main.getApplication().getResources().getIcon("save"));
        this.btnSaveNames.setToolTipText(s_stringMgr.getString("TableExportSelectionPanel.save.names.tooltip"));
        ret.add((Component)GUIUtils.styleAsToolbarButton(this.btnSaveNames), gbc);
        gbc = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0);
        this.btnApplySavedNames = new JButton(Main.getApplication().getResources().getIcon("open"));
        this.btnApplySavedNames.setToolTipText(s_stringMgr.getString("TableExportSelectionPanel.apply.saved.names.tooltip"));
        ret.add((Component)GUIUtils.styleAsToolbarButton(this.btnApplySavedNames), gbc);
        gbc = new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0);
        this.btnInfo = new SmallToolTipInfoButton(s_stringMgr.getString("TableExportSelectionPanel.info.button"));
        ret.add((Component)this.btnInfo.getButton(), gbc);
        return ret;
    }
}

