/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.EditExcelTabOrFileNameCtrl;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExcelTabOrFileNamesDao;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDataInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportDialogType;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportSourceAccess;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ExportSqlNamed;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.JTableExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.MultipleSqlResultExportDestinationInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.SqlResultListEntry;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.SqlResultTabHandle;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.TableExportSelectionPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class TableExportSelectionPanelController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableExportSelectionPanelController.class);
    private final ExportSourceAccess _exportSourceAccess;
    private final ExportDialogType _exportDialogType;
    private TableExportSelectionPanel _pnl;
    private MultipleSqlResultExportDestinationInfo _currentExportDestinationInfo;

    public TableExportSelectionPanelController(ExportSourceAccess exportSourceAccess, ExportDialogType exportDialogType) {
        this._exportSourceAccess = exportSourceAccess;
        this._exportDialogType = exportDialogType;
        this._pnl = new TableExportSelectionPanel(exportDialogType);
        this._pnl.radCompleteTableOrSingleFile.addActionListener(e -> this.updateUI());
        if (this._exportDialogType == ExportDialogType.RESULT_SET_EXPORT) {
            this._pnl.chkLimitRows.addActionListener(e -> this.updateUI());
        } else if (this._exportDialogType == ExportDialogType.UI_TABLE_EXPORT) {
            this._pnl.radSelectionInUiTable.addActionListener(e -> this.updateUI());
        } else {
            throw new IllegalStateException("Unknown ExportDialogType: " + this._exportDialogType);
        }
        this._pnl.radMultipleSQLRes.addActionListener(e -> this.updateUI());
        this._pnl.btnUp.addActionListener(e -> this.onUp());
        this._pnl.btnDown.addActionListener(e -> this.onDown());
        this._pnl.btnEdit.addActionListener(e -> this.onEdit());
        this._pnl.btnDelete.addActionListener(e -> this.onDelete());
        this._pnl.btnSaveNames.addActionListener(e -> this.onSaveNames());
        this._pnl.btnApplySavedNames.addActionListener(e -> this.onApplySavedNames());
        this._pnl.lstSQLResultsToExport.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableExportSelectionPanelController.this.onListClicked(e);
            }
        });
    }

    private void onApplySavedNames() {
        List<String> savedNames = ExcelTabOrFileNamesDao.getSavedNames();
        if (savedNames.isEmpty()) {
            JOptionPane.showConfirmDialog(GUIUtils.getOwningWindow(this._pnl), s_stringMgr.getString("TableExportSelectionPanelController.no.names.saved"));
            return;
        }
        JPopupMenu menu = new JPopupMenu();
        for (String savedName : savedNames) {
            JMenuItem menuItem = new JMenuItem(savedName);
            menu.add(menuItem);
            menuItem.addActionListener(e -> this.onNamesSelected(savedName));
        }
        menu.show(this._pnl.btnApplySavedNames, 0, this._pnl.btnApplySavedNames.getHeight());
    }

    private void onNamesSelected(String savedName) {
        List<String> excelTabOrFileNames = ExcelTabOrFileNamesDao.getExcelTabOrFileNames(savedName);
        for (int i = 0; i < Math.min(excelTabOrFileNames.size(), this.getListModel().size()); ++i) {
            this.getListModel().getElementAt(i).setUserEnteredSqlResultNameFileNormalized(excelTabOrFileNames.get(i));
        }
        this._pnl.lstSQLResultsToExport.repaint();
    }

    private void onSaveNames() {
        if (this.getListModel().isEmpty()) {
            return;
        }
        List<String> excelTabOrFileNames = GUIUtils.getListItems(this.getListModel()).stream().map(i -> i.getExportNameFileNormalized()).collect(Collectors.toList());
        ExcelTabOrFileNamesDao.addOrReplaceSavedName(String.join((CharSequence)"/", excelTabOrFileNames), excelTabOrFileNames);
    }

    private DefaultListModel<SqlResultListEntry> getListModel() {
        return (DefaultListModel)this._pnl.lstSQLResultsToExport.getModel();
    }

    private void onUp() {
        int selectedIndex = this._pnl.lstSQLResultsToExport.getSelectedIndex();
        if (selectedIndex <= 0) {
            return;
        }
        SqlResultListEntry entry = this.getListModel().remove(selectedIndex);
        int newIndex = selectedIndex - 1;
        this.getListModel().add(newIndex, entry);
        this._pnl.lstSQLResultsToExport.setSelectedIndex(newIndex);
    }

    private void onDown() {
        int selectedIndex = this._pnl.lstSQLResultsToExport.getSelectedIndex();
        DefaultListModel<SqlResultListEntry> model = this.getListModel();
        if (selectedIndex < 0 || selectedIndex == model.size() - 1) {
            return;
        }
        SqlResultListEntry entry = model.remove(selectedIndex);
        int newIndex = selectedIndex + 1;
        model.add(newIndex, entry);
        this._pnl.lstSQLResultsToExport.setSelectedIndex(newIndex);
    }

    private void onEdit() {
        SqlResultListEntry selectedValue = this._pnl.lstSQLResultsToExport.getSelectedValue();
        if (null == selectedValue) {
            String msg = s_stringMgr.getString("TableExportSelectionPanelController.no.sql.result.selected");
            Main.getApplication().getMessageHandler().showWarningMessage(msg);
            return;
        }
        GUIUtils.getOwningWindow(this._pnl);
        EditExcelTabOrFileNameCtrl ctrl = new EditExcelTabOrFileNameCtrl(GUIUtils.getOwningWindow(this._pnl), selectedValue.toString());
        if (ctrl.isOk()) {
            selectedValue.setUserEnteredSqlResultNameFileNormalized(ctrl.getNewSqlResultNameFileNormalized());
        }
        this._pnl.lstSQLResultsToExport.repaint();
    }

    private void onDelete() {
        int selectedIndex = this._pnl.lstSQLResultsToExport.getSelectedIndex();
        if (-1 == selectedIndex) {
            String msg = s_stringMgr.getString("TableExportSelectionPanelController.no.sql.result.selected");
            Main.getApplication().getMessageHandler().showWarningMessage(msg);
            return;
        }
        ((DefaultListModel)this._pnl.lstSQLResultsToExport.getModel()).remove(selectedIndex);
        if (0 == this._pnl.lstSQLResultsToExport.getModel().getSize()) {
            return;
        }
        if (selectedIndex < this._pnl.lstSQLResultsToExport.getModel().getSize()) {
            this._pnl.lstSQLResultsToExport.setSelectedIndex(selectedIndex);
        } else {
            this._pnl.lstSQLResultsToExport.setSelectedIndex(this._pnl.lstSQLResultsToExport.getModel().getSize() - 1);
        }
    }

    private void onListClicked(MouseEvent e) {
        if (1 != e.getButton()) {
            return;
        }
        SqlResultListEntry selEntry = this._pnl.lstSQLResultsToExport.getSelectedValue();
        if (null == selEntry || null == selEntry.getHandle()) {
            return;
        }
        if (!selEntry.getHandle().isResultsVisible()) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("TableExportSelectionPanelController.warn.result.tab.not.visible"));
            return;
        }
        if (1 == e.getClickCount()) {
            if (null == selEntry) {
                return;
            }
            selEntry.getHandle().indicateTabComponent();
        } else if (2 == e.getClickCount()) {
            if (null == selEntry) {
                return;
            }
            selEntry.getHandle().selectResultTab();
            selEntry.getHandle().indicateTabComponent();
        }
    }

    public void initPanel(TableExportPreferences prefs) {
        boolean exportCompleteTableOrSingleFile = prefs.isExportCompleteTableOrSingleFile();
        boolean exportMultipleSQLResults = prefs.isExportMultipleSQLResults();
        if (this._exportDialogType == ExportDialogType.RESULT_SET_EXPORT) {
            if (1 < this._exportSourceAccess.getOriginalSqlsToExport().size()) {
                exportMultipleSQLResults = true;
                exportCompleteTableOrSingleFile = false;
            } else if (!(prefs.isFormatXLS() || prefs.isFormatXLSOld())) {
                exportMultipleSQLResults = false;
                exportCompleteTableOrSingleFile = true;
            }
        } else if (this._exportDialogType == ExportDialogType.UI_TABLE_EXPORT) {
            if (exportMultipleSQLResults && Main.getApplication().getMultipleSqlResultExportChannel().getSqlResultTabHandles().isEmpty()) {
                exportMultipleSQLResults = false;
                exportCompleteTableOrSingleFile = true;
            }
        } else {
            throw new IllegalStateException("Unknown ExportDialogType: " + this._exportDialogType);
        }
        if (exportMultipleSQLResults) {
            this._pnl.radMultipleSQLRes.setSelected(true);
        } else if (exportCompleteTableOrSingleFile) {
            this._pnl.radCompleteTableOrSingleFile.setSelected(true);
        } else if (this._exportDialogType == ExportDialogType.UI_TABLE_EXPORT) {
            this._pnl.radSelectionInUiTable.setSelected(true);
        }
        if (this._exportDialogType == ExportDialogType.RESULT_SET_EXPORT) {
            this._pnl.chkLimitRows.setSelected(prefs.isLimitRowsChecked());
            this._pnl.txtLimitRows.setText(prefs.getRowsLimit());
        }
        this.updateUI();
    }

    public void writeControlsToPrefs(TableExportPreferences prefs) {
        if (this._pnl.radMultipleSQLRes.isSelected()) {
            prefs.setExportMultipleSQLResults(true);
            prefs.setExportComplete(false);
        } else if (this._pnl.radCompleteTableOrSingleFile.isSelected()) {
            prefs.setExportMultipleSQLResults(false);
            prefs.setExportComplete(true);
        } else {
            prefs.setExportMultipleSQLResults(false);
            prefs.setExportComplete(false);
        }
        if (this._exportDialogType == ExportDialogType.RESULT_SET_EXPORT) {
            prefs.setLimitRowsChecked(this._pnl.chkLimitRows.isSelected());
            prefs.setRowsLimit(this._pnl.txtLimitRows.getText());
        }
    }

    private void updateUI() {
        this._pnl.lstSQLResultsToExport.setEnabled(this._pnl.radMultipleSQLRes.isSelected());
        this._pnl.btnUp.setEnabled(this._pnl.radMultipleSQLRes.isSelected());
        this._pnl.btnDown.setEnabled(this._pnl.radMultipleSQLRes.isSelected());
        this._pnl.btnEdit.setEnabled(this._pnl.radMultipleSQLRes.isSelected());
        this._pnl.btnDelete.setEnabled(this._pnl.radMultipleSQLRes.isSelected());
        this._pnl.btnSaveNames.setEnabled(this._pnl.radMultipleSQLRes.isSelected());
        this._pnl.btnApplySavedNames.setEnabled(this._pnl.radMultipleSQLRes.isSelected());
        this._pnl.btnInfo.setEnabled(this._pnl.radMultipleSQLRes.isSelected());
        this._pnl.txtExportFileOrDir.setEnabled(this._pnl.radMultipleSQLRes.isSelected());
        if (this._exportDialogType == ExportDialogType.RESULT_SET_EXPORT) {
            this._pnl.txtLimitRows.setEnabled(this._pnl.chkLimitRows.isSelected());
        }
        if (this._pnl.radMultipleSQLRes.isSelected()) {
            List listEntries;
            int[] indexCounter = new int[1];
            if (this._exportDialogType == ExportDialogType.UI_TABLE_EXPORT) {
                List<SqlResultTabHandle> sqlResultTabHandel = Main.getApplication().getMultipleSqlResultExportChannel().getSqlResultTabHandles();
                listEntries = sqlResultTabHandel.stream().map(h -> {
                    indexCounter[0] = indexCounter[0] + 1;
                    return new SqlResultListEntry((SqlResultTabHandle)h, indexCounter[0]);
                }).collect(Collectors.toList());
            } else {
                listEntries = this._exportSourceAccess.hasNamedSqls() ? this._exportSourceAccess.getExportSqlsNamed().stream().map(sqlNamed -> new SqlResultListEntry((ExportSqlNamed)sqlNamed)).collect(Collectors.toList()) : this._exportSourceAccess.getOriginalSqlsToExport().stream().map(sql -> {
                    indexCounter[0] = indexCounter[0] + 1;
                    return new SqlResultListEntry((String)sql, indexCounter[0]);
                }).collect(Collectors.toList());
            }
            SqlResultListEntry selEntry = this._pnl.lstSQLResultsToExport.getSelectedValue();
            DefaultListModel defaultListModel = new DefaultListModel();
            defaultListModel.addAll(listEntries);
            this._pnl.lstSQLResultsToExport.setModel(defaultListModel);
            if (null != selEntry) {
                Optional<SqlResultListEntry> match = listEntries.stream().filter(e -> e.toString().equals(selEntry.toString())).findFirst();
                if (match.isPresent()) {
                    this._pnl.lstSQLResultsToExport.setSelectedValue(selEntry, true);
                }
            } else if (!listEntries.isEmpty()) {
                this._pnl.lstSQLResultsToExport.setSelectedIndex(0);
            }
        } else {
            this._pnl.lstSQLResultsToExport.setModel(new DefaultListModel());
        }
    }

    public void updateExportDestinationInfo(String exportFileNameText, boolean destinationIsExcel) {
        this._pnl.txtExportFileOrDir.setText(s_stringMgr.getString("TableExportSelectionPanelController.export.location.unspecified"));
        this._currentExportDestinationInfo = null;
        if (StringUtilities.isEmpty(exportFileNameText, true)) {
            return;
        }
        File file = new File(exportFileNameText);
        if (file.isDirectory()) {
            if (!destinationIsExcel) {
                this._pnl.txtExportFileOrDir.setText(s_stringMgr.getString("TableExportSelectionPanelController.export.dir", file.getAbsolutePath()));
                this._currentExportDestinationInfo = MultipleSqlResultExportDestinationInfo.createExportDir(file);
            }
        } else if (!destinationIsExcel) {
            if (null != file.getParentFile()) {
                this._pnl.txtExportFileOrDir.setText(s_stringMgr.getString("TableExportSelectionPanelController.export.dir", file.getParentFile().getAbsolutePath()));
                this._currentExportDestinationInfo = MultipleSqlResultExportDestinationInfo.createExportDir(file.getParentFile());
            }
        } else {
            this._pnl.txtExportFileOrDir.setText(s_stringMgr.getString("TableExportSelectionPanelController.export.file", file.getAbsolutePath()));
            this._currentExportDestinationInfo = MultipleSqlResultExportDestinationInfo.createExcelExportFile(file);
        }
    }

    public JPanel getPanel() {
        return this._pnl;
    }

    public ExportSourceAccess getExportSourceAccess() {
        switch (this._exportDialogType) {
            case UI_TABLE_EXPORT: {
                this._exportSourceAccess.prepareSqlResultDataSetViewersExport(this.getSqlResultDataSetViewersExportData(), this._pnl.radSelectionInUiTable.isSelected(), this._currentExportDestinationInfo, this._pnl.radMultipleSQLRes.isSelected());
                return this._exportSourceAccess;
            }
            case RESULT_SET_EXPORT: {
                this._exportSourceAccess.prepareResultSetExport(this.getExportSqlsNamed(), this._pnl.radCompleteTableOrSingleFile.isSelected(), this._pnl.chkLimitRows.isSelected(), this._pnl.txtLimitRows.getInt(), this._currentExportDestinationInfo, this._pnl.radMultipleSQLRes.isSelected());
                return this._exportSourceAccess;
            }
        }
        throw new IllegalStateException("Unknown ExportDialogType: " + this._exportDialogType);
    }

    private List<ExportSqlNamed> getExportSqlsNamed() {
        if (!this._pnl.radMultipleSQLRes.isSelected()) {
            return Collections.emptyList();
        }
        ArrayList<ExportSqlNamed> ret = new ArrayList<ExportSqlNamed>();
        for (int i = 0; i < this.getListModel().getSize(); ++i) {
            SqlResultListEntry listEntry = this.getListModel().getElementAt(i);
            ret.add(new ExportSqlNamed(listEntry.getSql(), listEntry.getExportNameFileNormalized()));
        }
        return ret;
    }

    private List<ExportDataInfo> getSqlResultDataSetViewersExportData() {
        if (!this._pnl.radMultipleSQLRes.isSelected()) {
            return Collections.emptyList();
        }
        ArrayList<ExportDataInfo> ret = new ArrayList<ExportDataInfo>();
        for (int i = 0; i < this.getListModel().getSize(); ++i) {
            SqlResultListEntry listEntry = this.getListModel().getElementAt(i);
            SqlResultTabHandle handle = listEntry.getHandle();
            IDataSetViewer sqlResultDataSetViewer = handle.getSQLResultDataSetViewer();
            if (!(sqlResultDataSetViewer instanceof DataSetViewerTablePanel)) continue;
            DataSetViewerTable table = ((DataSetViewerTablePanel)sqlResultDataSetViewer).getTable();
            ret.add(new ExportDataInfo(new JTableExportData(table, true), listEntry.getExportNameFileNormalized()));
        }
        return ret;
    }

    public boolean isExportMultipleSQLResults() {
        return this._pnl.radMultipleSQLRes.isSelected();
    }
}

