/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.fileexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TaskDescriptionComponent
extends JComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TaskDescriptionComponent.class);
    private JTextField tfTargetFile;
    private JTextArea taSql;

    public TaskDescriptionComponent(String targetFile, String sql) {
        this();
        this.setTargetFile(targetFile);
        this.setSql(sql);
    }

    public void setSql(String sql) {
        this.taSql.setText(sql);
        this.taSql.setCaretPosition(0);
    }

    public void setTargetFile(String targetFile) {
        this.tfTargetFile.setText(targetFile);
    }

    public TaskDescriptionComponent() {
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createTitledBorder(i18n.TITEL_INFORMATION));
        this.setLayout(new BorderLayout());
        JPanel viewPanel = new JPanel();
        viewPanel.setMinimumSize(new Dimension(400, 200));
        viewPanel.setPreferredSize(new Dimension(400, 200));
        GridBagLayout gbl_viewPanel = new GridBagLayout();
        viewPanel.setLayout(gbl_viewPanel);
        this.add((Component)viewPanel, "Center");
        JLabel jlTargetFile = new JLabel();
        jlTargetFile.setHorizontalAlignment(4);
        jlTargetFile.setText(i18n.LABEL_FILE);
        GridBagConstraints gbc_jlTargetFile = new GridBagConstraints();
        gbc_jlTargetFile.insets = new Insets(0, 0, 5, 5);
        gbc_jlTargetFile.anchor = 13;
        gbc_jlTargetFile.gridx = 0;
        gbc_jlTargetFile.gridy = 0;
        viewPanel.add((Component)jlTargetFile, gbc_jlTargetFile);
        this.tfTargetFile = new JTextField();
        this.tfTargetFile.setEditable(false);
        GridBagConstraints gbc_tfTargetFile = new GridBagConstraints();
        gbc_tfTargetFile.weightx = 1.0;
        gbc_tfTargetFile.insets = new Insets(0, 0, 5, 0);
        gbc_tfTargetFile.fill = 2;
        gbc_tfTargetFile.gridx = 1;
        gbc_tfTargetFile.gridy = 0;
        viewPanel.add((Component)this.tfTargetFile, gbc_tfTargetFile);
        this.tfTargetFile.setColumns(10);
        JLabel lblSql = new JLabel();
        lblSql.setText(i18n.LABEL_SQL);
        GridBagConstraints gbc_lblSql = new GridBagConstraints();
        gbc_lblSql.anchor = 12;
        gbc_lblSql.insets = new Insets(0, 0, 5, 5);
        gbc_lblSql.gridx = 0;
        gbc_lblSql.gridy = 1;
        viewPanel.add((Component)lblSql, gbc_lblSql);
        this.taSql = new JTextArea();
        this.taSql.setEditable(false);
        JScrollPane spSql = new JScrollPane(this.taSql);
        GridBagConstraints gbc_spSql = new GridBagConstraints();
        gbc_spSql.weighty = 1.0;
        gbc_spSql.weightx = 1.0;
        gbc_spSql.insets = new Insets(0, 0, 5, 0);
        gbc_spSql.fill = 1;
        gbc_spSql.gridx = 1;
        gbc_spSql.gridy = 1;
        viewPanel.add((Component)spSql, gbc_spSql);
    }

    static interface i18n {
        public static final String TITEL_INFORMATION = s_stringMgr.getString("TaskDescriptionComponent.titelInformation");
        public static final String LABEL_FILE = s_stringMgr.getString("TaskDescriptionComponent.labelFile");
        public static final String LABEL_SQL = s_stringMgr.getString("TaskDescriptionComponent.labelSql");
    }
}

