/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.makeeditable;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTab;
import net.sourceforge.squirrel_sql.client.session.properties.DataSetViewerType;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.ShowReferencesUtil;
import net.sourceforge.squirrel_sql.fw.gui.action.UndoMakeEditableCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.makeeditable.MakeEditableCommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class MakeEditableToolbarCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MakeEditableToolbarCtrl.class);
    private final ResultTab _resultTab;
    private final ISession _session;
    private JToggleButton _button;

    public MakeEditableToolbarCtrl(ResultTab resultTab, ISession session) {
        this._resultTab = resultTab;
        this._session = session;
    }

    public JToggleButton getTabButton() {
        if (null == this._button) {
            if (this._resultTab.allowsEditing()) {
                if (this.isSqlResultTableEditableBySessionProperties() && !this.isTextOutput(this._resultTab)) {
                    this._button = GUIUtils.styleAsTabButton(new JToggleButton(Main.getApplication().getResources().getIcon("edit")));
                    this._button.setSelected(true);
                } else {
                    this._button = GUIUtils.styleAsTabButton(new JToggleButton(Main.getApplication().getResources().getIcon("edit")));
                }
                if (!this.isTextOutput(this._resultTab)) {
                    this._resultTab.getSQLResultDataSetViewer().getUpdateableModelReference().addListener(mode -> this._button.setSelected(mode));
                }
            } else {
                this._button = GUIUtils.styleAsTabButton(new JToggleButton(Main.getApplication().getResources().getIcon("editRedDot")));
            }
            this._button.addActionListener(e -> this.onButtonClicked());
            this._button.setToolTipText(s_stringMgr.getString("MakeEditableToolbarCtrl.toggle.editable.tooltip"));
        }
        return this._button;
    }

    private boolean isSqlResultTableEditableBySessionProperties() {
        return DataSetViewerType.EDITABLE_TABLE.getDataSetViewerClass().getName().equals(this._session.getProperties().getSQLResultsOutputClassName());
    }

    private void onButtonClicked() {
        try {
            if (this.isTextOutput(this._resultTab)) {
                this._button.setSelected(false);
                Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("MakeEditableToolbarCtrl.text.output"));
                return;
            }
            this._resultTab.selectSQLResultTabSelected();
            if (!this._resultTab.allowsEditing()) {
                List<Object> tables = new ArrayList();
                if (this._resultTab.getSQLResultDataSetViewer().getComponent() instanceof JTable) {
                    tables = ShowReferencesUtil.findTables((JTable)this._resultTab.getSQLResultDataSetViewer().getComponent(), this._session, true);
                }
                if (!tables.isEmpty()) {
                    JOptionPane.showMessageDialog(GUIUtils.getOwningWindow(this._button), s_stringMgr.getString("MakeEditableToolbarCtrl.uneditable.use.show.refs"));
                } else {
                    JOptionPane.showMessageDialog(GUIUtils.getOwningWindow(this._button), s_stringMgr.getString("MakeEditableToolbarCtrl.uneditable"));
                }
                this._button.setSelected(false);
            } else if (this._button.isSelected()) {
                new MakeEditableCommand(this._resultTab.getSQLResultDataSetViewer().getUpdateableModelReference()).execute();
                if (this._session.getSQLConnection().getAutoCommit()) {
                    Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("MakeEditableToolbarCtrl.was.made.editable.autocommit.true"));
                } else {
                    Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("MakeEditableToolbarCtrl.was.made.editable.autocommit.false"));
                }
            } else if (this.isSqlResultTableEditableBySessionProperties()) {
                JOptionPane.showMessageDialog(GUIUtils.getOwningWindow(this._button), s_stringMgr.getString("MakeEditableToolbarCtrl.cannot.make.uneditable.see.session.properties"));
                this._button.setSelected(true);
            } else {
                new UndoMakeEditableCommand(this._resultTab.getSQLResultDataSetViewer().getUpdateableModelReference()).execute();
                Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("MakeEditableToolbarCtrl.was.made.uneditable"));
            }
        }
        catch (SQLException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private boolean isTextOutput(ResultTab resultTab) {
        return DataSetViewerType.TEXT.getDataSetViewerClass().equals(resultTab.getSQLResultDataSetViewer().getClass());
    }
}

