/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.rowselectionwindow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TabButton;
import net.sourceforge.squirrel_sql.client.session.mainpanel.findresultcolumn.FindResultColumnUtil;
import net.sourceforge.squirrel_sql.client.session.mainpanel.rowcolandsum.RowColAndSumController;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanelUtil;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesChooserController;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ResultTableType;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DataSetViewerFindHandler;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.rowselectionwindow.RowSelectionTableUtil;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class RowsWindowFrame
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RowsWindowFrame.class);
    private static final String PREF_KEY_ROWS_WINDOW_FRAME_WIDTH = "Squirrel.rowselectionwindow.FrameWidth";
    private static final String PREF_KEY_ROWS_WINDOW_FRAME_HIGHT = "Squirrel.rowselectionwindow.FrameHight";
    private TabButton _btnToggleFind;
    private TabButton _btnToggleFindColumn;
    private final JPanel _contentPanel;
    private List<ColumnDisplayDefinition> _columnDisplayDefinitions;
    private ISession _session;
    private int _myCounterId;
    private DataSetViewerTablePanel _dataSetViewerTablePanel;
    private DataSetViewerFindHandler _dataSetViewerFindHandler;

    public RowsWindowFrame(Window parent, List<Object[]> rows, List<ColumnDisplayDefinition> columnDisplayDefinitions, ISession session) {
        super(parent);
        this._columnDisplayDefinitions = columnDisplayDefinitions;
        this._session = session;
        this._contentPanel = this.initContentPanel(rows);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(this._contentPanel);
        GUIUtils.initLocation(this, 500, 300);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RowsWindowFrame.this.onWindowClosing();
            }
        });
        this.setVisible(true);
    }

    private JPanel initContentPanel(List<Object[]> rows) {
        JPanel ret = new JPanel(new BorderLayout(0, 3));
        this._dataSetViewerTablePanel = DataSetViewerTablePanelUtil.createDataSetViewerTablePanel(rows, this._columnDisplayDefinitions, this._session);
        this._dataSetViewerFindHandler = new DataSetViewerFindHandler(this._dataSetViewerTablePanel, this._session, ResultTableType.ROWS_WINDOW, this);
        JPanel pnlNorth = this.createNorthPanel(this._dataSetViewerTablePanel);
        ret.add((Component)pnlNorth, "North");
        GUIUtils.forceProperty(() -> {
            ret.remove(this._dataSetViewerFindHandler.getComponent());
            ret.add(this._dataSetViewerFindHandler.getComponent(), "Center");
            this._dataSetViewerTablePanel.getTable().getDataSetViewerTableModel().fireTableDataChanged();
            this._dataSetViewerFindHandler.getComponent().doLayout();
            return this._dataSetViewerTablePanel.getTable().getRowCount() == 0 || 0 < this._dataSetViewerTablePanel.getTable().getSelectedRows().length;
        });
        return ret;
    }

    private JPanel createNorthPanel(DataSetViewerTablePanel dataSetViewerTablePanel) {
        JPanel ret = new JPanel(new BorderLayout());
        ret.add((Component)new JPanel(), "Center");
        JPanel pnlEast = new JPanel(new GridBagLayout());
        ret.add((Component)pnlEast, "East");
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(3, 3, 0, 0), 0, 0);
        RowColAndSumController rowColAndSumController = new RowColAndSumController();
        rowColAndSumController.setDataSetViewer(dataSetViewerTablePanel);
        rowColAndSumController.setRowColSumLayoutListener(() -> this.onRowColSumLayoutDone(ret));
        pnlEast.add((Component)rowColAndSumController.getPanel(), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 0, 0), 0, 0);
        MarkDuplicatesChooserController markDuplicatesChooserController = new MarkDuplicatesChooserController(dataSetViewerTablePanel);
        pnlEast.add((Component)GUIUtils.setPreferredWidth(GUIUtils.setPreferredHeight(markDuplicatesChooserController.getComponent(), 28), 45), gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 1, 0, 3), 0, 0);
        ImageIcon iconFindColumn = Main.getApplication().getResources().getIcon("findColumn");
        this._btnToggleFindColumn = GUIUtils.styleAsTabButton(new TabButton(iconFindColumn));
        this._btnToggleFindColumn.addActionListener(e -> this.onFindColumn());
        pnlEast.add((Component)this._btnToggleFindColumn, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 1, 0, 3), 0, 0);
        ImageIcon iconFind = Main.getApplication().getResources().getIcon("find");
        this._btnToggleFind = GUIUtils.styleAsTabButton(new TabButton(iconFind));
        this._btnToggleFind.addActionListener(e -> this.onFind());
        pnlEast.add((Component)this._btnToggleFind, gbc);
        return ret;
    }

    private void onFindColumn() {
        FindResultColumnUtil.findAndShowResultColumns(this._dataSetViewerTablePanel, this);
    }

    private void onFind() {
        this._dataSetViewerFindHandler.toggleShowFindPanel();
    }

    private void onRowColSumLayoutDone(JPanel pnlNorth) {
        pnlNorth.revalidate();
    }

    private void onWindowClosing() {
        Dimension size = this.getSize();
        Props.putInt(PREF_KEY_ROWS_WINDOW_FRAME_WIDTH, size.width);
        Props.putInt(PREF_KEY_ROWS_WINDOW_FRAME_HIGHT, size.height);
        Main.getApplication().getRowsWindowFrameRegistry().remove(this);
    }

    public void appendSelectedRows(List<Object[]> rows, ArrayList<ColumnDisplayDefinition> columnDisplayDefinitions) {
        HashMap<Integer, Integer> myIndexByOtherIndexMap = this.getMyIndexByOtherIndexMap(columnDisplayDefinitions);
        if (null == myIndexByOtherIndexMap) {
            throw new IllegalStateException("appendSelectedRows() should be called after columnsMatch() was called to check.");
        }
        for (Object[] row : rows) {
            Object[] myRow = new Object[row.length];
            for (int i = 0; i < row.length; ++i) {
                myRow[myIndexByOtherIndexMap.get((Object)Integer.valueOf((int)i)).intValue()] = row[i];
            }
            RowSelectionTableUtil.getActualTableModel(this._dataSetViewerTablePanel).addRow(myRow);
        }
        RowSelectionTableUtil.getActualTableModel(this._dataSetViewerTablePanel).allRowsAdded();
        DataSetViewerTable table = this._dataSetViewerTablePanel.getTable();
        table.getDataSetViewerTableModel().fireTableDataChanged();
        table.validate();
        SwingUtilities.invokeLater(() -> this.scrollTableToBottom(table));
    }

    private void scrollTableToBottom(JTable table) {
        int rowCount = RowSelectionTableUtil.getActualTableModel(table).getRowCount();
        Rectangle cellRect = table.getCellRect(rowCount, 0, true);
        Rectangle visibleRect = table.getVisibleRect();
        cellRect.x = visibleRect.x;
        cellRect.height = 1;
        cellRect.width = 1;
        cellRect.y = 1000000;
        table.scrollRectToVisible(cellRect);
    }

    public void close() {
        this.onWindowClosing();
        this.setVisible(false);
        this.dispose();
    }

    public boolean columnsMatch(ArrayList<ColumnDisplayDefinition> otherCols) {
        return null != this.getMyIndexByOtherIndexMap(otherCols);
    }

    private HashMap<Integer, Integer> getMyIndexByOtherIndexMap(ArrayList<ColumnDisplayDefinition> otherCols) {
        if (this._columnDisplayDefinitions.size() != otherCols.size()) {
            return null;
        }
        HashMap<Integer, Integer> myIndexByOthersIndex = new HashMap<Integer, Integer>();
        ArrayList<ColumnDisplayDefinition> myColsBuf = new ArrayList<ColumnDisplayDefinition>(this._columnDisplayDefinitions);
        HashSet<Integer> usedIncicesOfMine = new HashSet<Integer>();
        for (int i = 0; i < otherCols.size(); ++i) {
            ColumnDisplayDefinition otherCol = otherCols.get(i);
            boolean found = false;
            for (int j = 0; j < myColsBuf.size(); ++j) {
                ColumnDisplayDefinition myCol = myColsBuf.get(j);
                if (!this.match(otherCol, myCol) || usedIncicesOfMine.contains(j)) continue;
                myIndexByOthersIndex.put(i, j);
                usedIncicesOfMine.add(j);
                found = true;
                break;
            }
            if (found) continue;
            myIndexByOthersIndex = null;
            break;
        }
        return myIndexByOthersIndex;
    }

    private boolean match(ColumnDisplayDefinition col1, ColumnDisplayDefinition col2) {
        return Utilities.equalsRespectNull(col1.getColumnName(), col2.getColumnName()) && col1.getSqlType() == col2.getSqlType();
    }

    public void setMyCounterId(int myCounterId) {
        this._myCounterId = myCounterId;
        this.setTitle(s_stringMgr.getString("RowsWindowFrame.title") + " / " + (null != this._session ? this._session.getTitle() : "") + " / (" + this._myCounterId + ")");
    }

    public void markWindow(boolean b) {
        if (b) {
            this._contentPanel.setBorder(BorderFactory.createLineBorder(Color.red, 3));
        } else {
            this._contentPanel.setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

