/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.showdistinctvalues;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.gui.action.showdistinctvalues.DistinctValuesData;
import net.sourceforge.squirrel_sql.fw.gui.action.showdistinctvalues.DistinctValuesUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DistinctValuesHolder {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DistinctValuesHolder.class);
    private HashMap<Integer, DistinctValuesData> _colIx_distinctValuesData = new HashMap();
    private boolean _nullsAdded;

    public void addDistinct(int colIx, Object value) {
        DistinctValuesData distinctValuesData = this._colIx_distinctValuesData.computeIfAbsent(colIx, ix -> new DistinctValuesData());
        distinctValuesData.addUnique(value);
    }

    public List<Object[]> getDistinctRows() {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (int rowIx = 0; rowIx < this.getMaxDistinctValues(); ++rowIx) {
            Object[] row = 1 == this._colIx_distinctValuesData.size() ? new Object[2] : new Object[this._colIx_distinctValuesData.size()];
            for (int colIx = 0; colIx < this._colIx_distinctValuesData.size(); ++colIx) {
                if (rowIx < this._colIx_distinctValuesData.get(colIx).size()) {
                    row[colIx] = this._colIx_distinctValuesData.get(colIx).getValue(rowIx);
                    continue;
                }
                this._nullsAdded = true;
            }
            if (1 == this._colIx_distinctValuesData.size()) {
                row[1] = this._colIx_distinctValuesData.get(0).getValueCount(rowIx);
            }
            ret.add(row);
        }
        return ret;
    }

    private int getMaxDistinctValues() {
        return this._colIx_distinctValuesData.values().stream().mapToInt(d -> d.size()).max().getAsInt();
    }

    public int getCountDistinctForColumn(int colIx) {
        return this._colIx_distinctValuesData.get(colIx).size();
    }

    public boolean isNullsAdded() {
        return this._nullsAdded;
    }

    public List<ColumnDisplayDefinition> maybeAppendCountColumn(List<ColumnDisplayDefinition> originalDisplayDefinitions) {
        if (1 != this._colIx_distinctValuesData.size()) {
            return originalDisplayDefinitions;
        }
        ArrayList<ColumnDisplayDefinition> ret = new ArrayList<ColumnDisplayDefinition>(originalDisplayDefinitions);
        ColumnDisplayDefinition dispDef = DistinctValuesUtil.createFrequencyColumn();
        ret.add(dispDef);
        return ret;
    }
}

