/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.showdistinctvalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanelUtil;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.action.showdistinctvalues.DistinctRowsHolder;
import net.sourceforge.squirrel_sql.fw.gui.action.showdistinctvalues.DistinctValuesHolder;
import net.sourceforge.squirrel_sql.fw.gui.action.showdistinctvalues.DistinctValuesUtil;
import net.sourceforge.squirrel_sql.fw.gui.action.showdistinctvalues.ShowDistinctValuesDlg;
import net.sourceforge.squirrel_sql.fw.gui.table.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DistinctValuesTableUpdater {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DistinctValuesTableUpdater.class);
    public static final ILogger s_log = LoggerController.createLogger(DistinctValuesTableUpdater.class);
    private ShowDistinctValuesDlg _dlg;

    public DistinctValuesTableUpdater(ShowDistinctValuesDlg dlg) {
        this._dlg = dlg;
    }

    void updateTable(DataSetViewerTable sourceTable, ExtTableColumn selectedColumn) {
        this._dlg.btnStatusBarInfoToolTip.setInfoText(s_stringMgr.getString("ShowDistinctValuesCtrl.noInformation"));
        this._dlg.lblStatus.setText(null);
        if (this._dlg.optDistinctInColumn.isSelected()) {
            long begMillis = System.currentTimeMillis();
            DistinctValuesHolder distinctValuesHolder = new DistinctValuesHolder();
            for (int i = 0; i < sourceTable.getDataSetViewerTableModel().getRowCount(); ++i) {
                distinctValuesHolder.addDistinct(0, sourceTable.getValueAt(i, this.getViewColumnIndex(sourceTable, selectedColumn)));
            }
            List<Object[]> distinctRows = distinctValuesHolder.getDistinctRows();
            this.fillTablePanel(distinctRows, distinctValuesHolder.maybeAppendCountColumn(Collections.singletonList(selectedColumn.getColumnDisplayDefinition())));
            long distinctValuesTime = System.currentTimeMillis() - begMillis;
            s_log.info("Building distinct values took " + distinctValuesTime + " Milli seconds");
            this._dlg.lblStatus.setText(s_stringMgr.getString("ShowDistinctValuesCtrl.numberOfDistinctValuesInColumn", selectedColumn.getColumnDisplayDefinition().getColumnName(), distinctRows.size()));
        } else if (this._dlg.optDistinctInSelection.isSelected()) {
            int[] selRows = sourceTable.getSelectedRows();
            ArrayList<ExtTableColumn> extTableColumns = this.getSelectedExtTableColumns(sourceTable);
            if (this._dlg.optDistinctInColumns.isSelected()) {
                long begMillis = System.currentTimeMillis();
                DistinctValuesHolder distinctValuesHolder = new DistinctValuesHolder();
                for (int selRowIx : selRows) {
                    for (int i = 0; i < extTableColumns.size(); ++i) {
                        distinctValuesHolder.addDistinct(i, sourceTable.getValueAt(selRowIx, this.getViewColumnIndex(sourceTable, extTableColumns.get(i))));
                    }
                }
                List<ColumnDisplayDefinition> list = extTableColumns.stream().map(c -> c.getColumnDisplayDefinition()).collect(Collectors.toList());
                this.fillTablePanel(distinctValuesHolder.getDistinctRows(), distinctValuesHolder.maybeAppendCountColumn(list));
                long distinctValuesTime = System.currentTimeMillis() - begMillis;
                s_log.info("Building distinct values took " + distinctValuesTime + " Milli seconds");
                this.writeDistinctInColumnsStatusBar(extTableColumns, distinctValuesHolder);
            } else {
                this.doDistinctRows(sourceTable, sourceTable.getSelectedModelRows(), extTableColumns);
            }
        } else if (this._dlg.optDistinctInSelectedRows.isSelected()) {
            int[] selRows = sourceTable.getSelectedRows();
            ArrayList<ExtTableColumn> extTableColumns = this.getAllExtTableColumns(sourceTable);
            if (this._dlg.optDistinctInColumns.isSelected()) {
                long begMillis = System.currentTimeMillis();
                DistinctValuesHolder distinctValuesHolder = new DistinctValuesHolder();
                for (int selRowIx : selRows) {
                    for (int i = 0; i < extTableColumns.size(); ++i) {
                        distinctValuesHolder.addDistinct(i, sourceTable.getValueAt(selRowIx, this.getViewColumnIndex(sourceTable, extTableColumns.get(i))));
                    }
                }
                List<ColumnDisplayDefinition> list = extTableColumns.stream().map(c -> c.getColumnDisplayDefinition()).collect(Collectors.toList());
                this.fillTablePanel(distinctValuesHolder.getDistinctRows(), distinctValuesHolder.maybeAppendCountColumn(list));
                long distinctValuesTime = System.currentTimeMillis() - begMillis;
                s_log.info("Building distinct values took " + distinctValuesTime + " Milli seconds");
                this.writeDistinctInColumnsStatusBar(extTableColumns, distinctValuesHolder);
            } else {
                this.doDistinctRows(sourceTable, sourceTable.getSelectedModelRows(), extTableColumns);
            }
        } else if (this._dlg.optDistinctInTable.isSelected()) {
            ArrayList<ExtTableColumn> extTableColumns = this.getAllExtTableColumns(sourceTable);
            if (this._dlg.optDistinctInColumns.isSelected()) {
                long begMillis = System.currentTimeMillis();
                DistinctValuesHolder distinctValuesHolder = new DistinctValuesHolder();
                for (int rowIx = 0; rowIx < sourceTable.getRowCount(); ++rowIx) {
                    for (int i = 0; i < extTableColumns.size(); ++i) {
                        distinctValuesHolder.addDistinct(i, sourceTable.getValueAt(rowIx, this.getViewColumnIndex(sourceTable, extTableColumns.get(i))));
                    }
                }
                List<ColumnDisplayDefinition> columnDisplayDefinitions = extTableColumns.stream().map(c -> c.getColumnDisplayDefinition()).collect(Collectors.toList());
                this.fillTablePanel(distinctValuesHolder.getDistinctRows(), distinctValuesHolder.maybeAppendCountColumn(columnDisplayDefinitions));
                long l = System.currentTimeMillis() - begMillis;
                s_log.info("Building distinct values took " + l + " Milli seconds");
                this.writeDistinctInColumnsStatusBar(extTableColumns, distinctValuesHolder);
            } else {
                this.doDistinctRows(sourceTable, null, extTableColumns);
            }
        }
    }

    private void fillTablePanel(List<Object[]> distinctRows, List<ColumnDisplayDefinition> columnDisplayDefinitions) {
        DataSetViewerTablePanel dataSetViewerTablePanel = DataSetViewerTablePanelUtil.createDataSetViewerTablePanel(distinctRows, columnDisplayDefinitions);
        this._dlg.distinctTableScrollPane.setViewportView(dataSetViewerTablePanel.getComponent());
    }

    private int getViewColumnIndex(DataSetViewerTable sourceTable, ExtTableColumn column) {
        return sourceTable.getButtonTableHeader().getViewColumnIndex(column.getModelIndex());
    }

    private void doDistinctRows(DataSetViewerTable sourceTable, int[] selRows, ArrayList<ExtTableColumn> extTableColumns) {
        long begMillis = System.currentTimeMillis();
        DistinctRowsHolder distinctRowsHolder = new DistinctRowsHolder(extTableColumns);
        if (null != selRows) {
            for (int selRowIx : selRows) {
                distinctRowsHolder.addRowDistinct(sourceTable.getDataSetViewerTableModel().getRowAt(selRowIx));
            }
        } else {
            for (int viewRowIx = 0; viewRowIx < sourceTable.getRowCount(); ++viewRowIx) {
                int modelRowIx = ((SortableTableModel)sourceTable.getModel()).transformToModelRow(viewRowIx);
                distinctRowsHolder.addRowDistinct(sourceTable.getDataSetViewerTableModel().getRowAt(modelRowIx));
            }
        }
        List<ColumnDisplayDefinition> columnDisplayDefinitions = extTableColumns.stream().map(c -> c.getColumnDisplayDefinition()).collect(Collectors.toList());
        columnDisplayDefinitions.add(DistinctValuesUtil.createFrequencyColumn());
        this.fillTablePanel(distinctRowsHolder.getDistinctRows(), columnDisplayDefinitions);
        this.writeDistinctInRowStatusBar(distinctRowsHolder);
        long distinctRowsTime = System.currentTimeMillis() - begMillis;
        s_log.info("Building distinct rows took " + distinctRowsTime + " Milli seconds");
    }

    private void writeDistinctInRowStatusBar(DistinctRowsHolder distinctRowsHolder) {
        String statusBarText = s_stringMgr.getString("ShowDistinctValuesCtrl.numberOfDistinctRows", distinctRowsHolder.getDistinctRowsCount());
        this._dlg.lblStatus.setText(statusBarText);
        this._dlg.lblStatus.setCaretPosition(0);
    }

    private void writeDistinctInColumnsStatusBar(ArrayList<ExtTableColumn> extTableColumns, DistinctValuesHolder distinctValuesHolder) {
        Object statusBarText = null;
        for (int i = 0; i < extTableColumns.size(); ++i) {
            ExtTableColumn extTableColumn = extTableColumns.get(i);
            String distinctValuesString = s_stringMgr.getString("ShowDistinctValuesCtrl.numberOfDistinctValuesInColumn", extTableColumn.getColumnDisplayDefinition().getColumnName(), distinctValuesHolder.getCountDistinctForColumn(i));
            statusBarText = null == statusBarText ? distinctValuesString : (String)statusBarText + "; " + distinctValuesString;
        }
        this._dlg.lblStatus.setText((String)statusBarText);
        this._dlg.lblStatus.setCaretPosition(0);
        if (distinctValuesHolder.isNullsAdded()) {
            this._dlg.btnStatusBarInfoToolTip.setInfoText(s_stringMgr.getString("ShowDistinctValuesCtrl.information.nullsAdded"));
        }
    }

    private ArrayList<ExtTableColumn> getSelectedExtTableColumns(DataSetViewerTable sourceTable) {
        int[] selCols = sourceTable.getSelectedColumns();
        ArrayList<ExtTableColumn> extTableColumns = new ArrayList<ExtTableColumn>();
        for (int colIdx : selCols) {
            TableColumn col = sourceTable.getColumnModel().getColumn(colIdx);
            if (!(col instanceof ExtTableColumn)) continue;
            extTableColumns.add((ExtTableColumn)col);
        }
        return extTableColumns;
    }

    private ArrayList<ExtTableColumn> getAllExtTableColumns(DataSetViewerTable sourceTable) {
        ArrayList<ExtTableColumn> extTableColumns = new ArrayList<ExtTableColumn>();
        for (int colIdx = 0; colIdx < sourceTable.getColumnCount(); ++colIdx) {
            TableColumn col = sourceTable.getColumnModel().getColumn(colIdx);
            if (!(col instanceof ExtTableColumn)) continue;
            extTableColumns.add((ExtTableColumn)col);
        }
        return extTableColumns;
    }
}

