/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.showdistinctvalues;

import java.awt.Window;
import javax.swing.Timer;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.showdistinctvalues.DistinctValuesTableUpdater;
import net.sourceforge.squirrel_sql.fw.gui.action.showdistinctvalues.ShowDistinctValuesDlg;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ShowDistinctValuesCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ShowDistinctValuesCtrl.class);
    private static final String PREF_DISTINCT_IN_COLUMN = "ShowDistinctValuesCtrl.optDistinctInColumn";
    private static final String PREF_DISTINCT_IN_SELECTION = "ShowDistinctValuesCtrl.optDistinctInSelection";
    private static final String PREF_DISTINCT_IN_SELECTED_ROWS = "ShowDistinctValuesCtrl.optDistinctInSelectedRows";
    private static final String PREF_DISTINCT_IN_TABLE = "ShowDistinctValuesCtrl.optDistinctInTable";
    private static final String PREF_DISTINCT_IN_ROWS = "ShowDistinctValuesCtrl.optDistinctInRows";
    private ShowDistinctValuesDlg _dlg;
    private Timer _distinctTableUpdateTrigger;

    public ShowDistinctValuesCtrl(Window owningWindow, DataSetViewerTable sourceTable) {
        TableColumn selectedColumn;
        if (0 == sourceTable.getDataSetViewerTableModel().getRowCount()) {
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ShowDistinctValuesCtrl.emptyTable"));
            return;
        }
        int selectedColumnIx = sourceTable.getSelectedColumn();
        if (-1 == selectedColumnIx) {
            selectedColumnIx = 0;
        }
        if (!((selectedColumn = sourceTable.getColumnModel().getColumn(selectedColumnIx)) instanceof ExtTableColumn)) {
            Main.getApplication().getMessageHandler().showErrorMessage(s_stringMgr.getString("ShowDistinctValuesCtrl.unableToShowDistinctValuesForColumn", selectedColumn.getHeaderValue()));
            return;
        }
        this._dlg = new ShowDistinctValuesDlg(owningWindow, ((ExtTableColumn)selectedColumn).getColumnDisplayDefinition().getColumnName());
        this._dlg.optDistinctInColumn.setSelected(Props.getBoolean(PREF_DISTINCT_IN_COLUMN, true));
        this._dlg.optDistinctInSelection.setSelected(Props.getBoolean(PREF_DISTINCT_IN_SELECTION, false));
        this._dlg.optDistinctInSelectedRows.setSelected(Props.getBoolean(PREF_DISTINCT_IN_SELECTED_ROWS, false));
        this._dlg.optDistinctInTable.setSelected(Props.getBoolean(PREF_DISTINCT_IN_TABLE, false));
        this._dlg.optDistinctInRows.setSelected(Props.getBoolean(PREF_DISTINCT_IN_ROWS, false));
        this._dlg.optDistinctInColumns.setSelected(false == Props.getBoolean(PREF_DISTINCT_IN_ROWS, false));
        this.onDistinctInColumnOrSelectionChanged();
        this._distinctTableUpdateTrigger = new Timer(300, e -> new DistinctValuesTableUpdater(this._dlg).updateTable(sourceTable, (ExtTableColumn)selectedColumn));
        this._distinctTableUpdateTrigger.setRepeats(false);
        this.triggerTableUpdate();
        this._dlg.optDistinctInColumn.addActionListener(e -> this.onDistinctInColumnOrSelectionChanged());
        this._dlg.optDistinctInSelection.addActionListener(e -> this.onDistinctInColumnOrSelectionChanged());
        this._dlg.optDistinctInSelectedRows.addActionListener(e -> this.onDistinctInColumnOrSelectionChanged());
        this._dlg.optDistinctInTable.addActionListener(e -> this.onDistinctInColumnOrSelectionChanged());
        this._dlg.optDistinctInColumn.addActionListener(e -> this.triggerTableUpdate());
        this._dlg.optDistinctInSelection.addActionListener(e -> this.triggerTableUpdate());
        this._dlg.optDistinctInSelectedRows.addActionListener(e -> this.triggerTableUpdate());
        this._dlg.optDistinctInTable.addActionListener(e -> this.triggerTableUpdate());
        this._dlg.optDistinctInRows.addActionListener(e -> this.triggerTableUpdate());
        this._dlg.optDistinctInColumns.addActionListener(e -> this.triggerTableUpdate());
        GUIUtils.initLocation(this._dlg, 500, 500);
        GUIUtils.enableCloseByEscape(this._dlg);
        this._dlg.setVisible(true);
    }

    private void triggerTableUpdate() {
        Props.putBoolean(PREF_DISTINCT_IN_COLUMN, this._dlg.optDistinctInColumn.isSelected());
        Props.putBoolean(PREF_DISTINCT_IN_SELECTION, this._dlg.optDistinctInSelection.isSelected());
        Props.putBoolean(PREF_DISTINCT_IN_SELECTED_ROWS, this._dlg.optDistinctInSelectedRows.isSelected());
        Props.putBoolean(PREF_DISTINCT_IN_TABLE, this._dlg.optDistinctInTable.isSelected());
        Props.putBoolean(PREF_DISTINCT_IN_ROWS, this._dlg.optDistinctInRows.isSelected());
        this._distinctTableUpdateTrigger.restart();
    }

    private void onDistinctInColumnOrSelectionChanged() {
        if (this._dlg.optDistinctInColumn.isSelected()) {
            this._dlg.optDistinctInColumns.setSelected(true);
            this._dlg.optDistinctInColumns.setEnabled(false);
            this._dlg.optDistinctInRows.setEnabled(false);
        } else {
            this._dlg.optDistinctInColumns.setEnabled(true);
            this._dlg.optDistinctInRows.setEnabled(true);
        }
    }
}

