/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.showreferences;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultMetaDataTable;
import net.sourceforge.squirrel_sql.fw.gui.action.InStatColumnInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.ShowQualifiedListener;

public class RootTable {
    private final ResultMetaDataTable _globalDbTable;
    private final ArrayList<InStatColumnInfo> _inStatColumnInfos;
    private boolean _showQualified;

    public RootTable(ResultMetaDataTable globalDbTable, ArrayList<InStatColumnInfo> inStatColumnInfos) {
        this._globalDbTable = globalDbTable;
        this._inStatColumnInfos = inStatColumnInfos;
    }

    public ResultMetaDataTable getGlobalDbTable() {
        return this._globalDbTable;
    }

    public ArrayList<InStatColumnInfo> getInStatColumnInfos() {
        return this._inStatColumnInfos;
    }

    public String toString() {
        if (this._showQualified) {
            return this._globalDbTable.getQualifiedName();
        }
        return this._globalDbTable.getTableName();
    }

    public String getFrameTitle() {
        Object ret = this.getGlobalDbTable().getQualifiedName();
        for (InStatColumnInfo inStatColumnInfo : this._inStatColumnInfos) {
            ret = (String)ret + " [" + inStatColumnInfo.getInStatement() + "]";
        }
        return ret;
    }

    public ShowQualifiedListener getShowQualifiedListener() {
        return b -> {
            this._showQualified = b;
        };
    }
}

