/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.buttonchooser;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonChooserOrientation;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonHolder;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonSelectedListener;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ComboButton;

public class ButtonChooser {
    private JButton _btnUndefinedDefault;
    private ComboButton _btnCombo;
    private AbstractButton _btnCurrent;
    private List<ButtonHolder> _buttons = new ArrayList<ButtonHolder>();
    private ButtonSelectedListener _buttonSelectedListener;
    private HashSet<JButton> _unclickableButtons = new HashSet();
    private JComponent _container;
    private boolean _inToolBar;
    private ButtonChooserOrientation _orientation;

    public ButtonChooser() {
        this(false, ButtonChooserOrientation.RIGHT);
    }

    public ButtonChooser(boolean inToolBar) {
        this(inToolBar, ButtonChooserOrientation.RIGHT);
    }

    public ButtonChooser(boolean inToolBar, ButtonChooserOrientation orientation) {
        this._inToolBar = inToolBar;
        this._orientation = orientation;
        this._btnCombo = new ComboButton();
        if (this._inToolBar) {
            JToolBar toolBarComp = new JToolBar();
            toolBarComp.setBorder(BorderFactory.createEmptyBorder());
            toolBarComp.setFloatable(false);
            toolBarComp.setRollover(true);
            GUIUtils.inheritBackground(toolBarComp);
            this._container = toolBarComp;
        } else {
            this._container = new JPanel(new GridBagLayout());
            GUIUtils.styleAsToolbarButton(this._btnCombo);
        }
        this.createUI();
        this.initListeners();
    }

    public JComponent getComponent() {
        return this._container;
    }

    private void initListeners() {
        this._btnCombo.addActionListener(e -> this.onShowPopup());
    }

    private void onShowPopup() {
        JPopupMenu comboPopUp = new JPopupMenu();
        for (ButtonHolder buttonHolder : this._buttons) {
            JMenuItem mnu = new JMenuItem(buttonHolder.getText(), buttonHolder.getBtn().getIcon());
            mnu.setToolTipText(buttonHolder.getBtn().getToolTipText());
            mnu.addActionListener(e -> this.displayAsCurrentButton(buttonHolder.getBtn()));
            comboPopUp.add(mnu);
        }
        comboPopUp.addPopupMenuListener(this._btnCombo.getPopupMenuListener());
        comboPopUp.show(this._btnCurrent, 0, this._btnCurrent.getHeight());
    }

    private void createUI() {
        SquirrelResources rsrc = Main.getApplication().getResources();
        ImageIcon iconUndefined = rsrc.getIcon("undefined");
        this._btnUndefinedDefault = new JButton(iconUndefined);
        this._btnUndefinedDefault.setToolTipText("There were no buttons added???");
        this.displayAsCurrentButton(this._btnUndefinedDefault);
        if (this._inToolBar) {
            this._container.add(this._btnCombo);
        } else {
            GridBagConstraints gbc = this._orientation == ButtonChooserOrientation.RIGHT ? new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 2), 0, 0) : new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
            this._container.add((Component)this._btnCombo, gbc);
        }
    }

    public void addButton(AbstractButton btn) {
        this._buttons.add(new ButtonHolder(btn));
        if (!this._inToolBar) {
            GUIUtils.styleAsToolbarButton(btn);
        }
        if (this._btnCurrent == this._btnUndefinedDefault) {
            this.setSelectedButton(btn);
        }
    }

    public void addUnclickableButton(JButton btn) {
        btn.setEnabled(false);
        btn.setDisabledIcon(btn.getIcon());
        if (!this._inToolBar) {
            GUIUtils.styleAsToolbarButton(btn);
        }
        this._unclickableButtons.add(btn);
        this.addButton(btn);
    }

    public void setSelectedButton(AbstractButton btn) {
        if (!this._buttons.stream().filter(bh -> bh.getBtn() == btn).findFirst().isPresent()) {
            throw new IllegalStateException("Button must be added before being selected");
        }
        this.displayAsCurrentButton(btn);
    }

    private void displayAsCurrentButton(AbstractButton btn) {
        AbstractButton formerSelectedButton = this._btnCurrent;
        if (null != this._btnCurrent) {
            this._container.remove(this._btnCurrent);
        }
        this._btnCurrent = btn;
        this._btnCombo.setLinkedButton(this._btnCurrent);
        if (this._inToolBar) {
            if (this._orientation == ButtonChooserOrientation.RIGHT) {
                this._container.add((Component)this._btnCurrent, 0);
            } else {
                this._container.add(this._btnCurrent);
            }
        } else if (this._orientation == ButtonChooserOrientation.RIGHT) {
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
            this._container.add(this._btnCurrent, gbc, 0);
        } else {
            GridBagConstraints gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
            this._container.add((Component)this._btnCurrent, gbc);
        }
        this._container.revalidate();
        this._container.repaint();
        if (null != this._buttonSelectedListener) {
            this._buttonSelectedListener.buttonSelected(this._btnCurrent, formerSelectedButton);
        }
    }

    public void setButtonSelectedListener(ButtonSelectedListener buttonSelectedListener) {
        this._buttonSelectedListener = buttonSelectedListener;
    }

    public void setChooserEnabled(boolean b) {
        this._btnCombo.setEnabled(b);
        if (b) {
            this._unclickableButtons.forEach(btn -> btn.setDisabledIcon(btn.getIcon()));
        } else {
            this._unclickableButtons.forEach(btn -> btn.setDisabledIcon(null));
        }
        if (!this._unclickableButtons.contains(this._btnCurrent)) {
            this._btnCurrent.setEnabled(b);
        }
    }

    public AbstractButton getSelectedButton() {
        return this._btnCurrent;
    }

    public List<AbstractButton> getAllButtons() {
        return this._buttons.stream().map(bh -> bh.getBtn()).collect(Collectors.toList());
    }

    public void setPreferredHeight(int height) {
        GUIUtils.setPreferredHeight(this._container, height);
    }
}

