/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.buttonchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.sourceforge.squirrel_sql.client.Main;

public class ComboButton
extends JToggleButton {
    private static final int TRI_HEIGHT = 3;
    private static final int DIST = 3;
    private AbstractButton linkedButton;
    private transient MouseListener hoverHandler = new HoverHandler();
    private transient KeyListener actionKeyHandler = new ActionKeyHandler();

    public ComboButton() {
        super.setFocusable(false);
        super.addMouseListener(this.hoverHandler);
    }

    private int getMaxWidth() {
        return Main.getApplication().getIconHandler().iconScale_ceil(12);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        int maxWidth = this.getMaxWidth();
        return new Dimension(maxWidth, maxWidth);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        int maxWidth = this.getMaxWidth();
        return this.linkedButton == null ? new Dimension(maxWidth, maxWidth * 2) : new Dimension(maxWidth, this.linkedButton.getPreferredSize().height);
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        int maxWidth = this.getMaxWidth();
        if (this.linkedButton == null) {
            return new Dimension(maxWidth, Short.MAX_VALUE);
        }
        return new Dimension(maxWidth, this.linkedButton.getMaximumSize().height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        if (this.isEnabled()) {
            g.setColor(this.getForeground());
        } else {
            g.setColor(Color.gray);
        }
        Polygon pg = new Polygon();
        int scaledHeight = Main.getApplication().getIconHandler().iconScale_round(3);
        int scaledDist = Main.getApplication().getIconHandler().iconScale_round(3);
        pg.addPoint(scaledDist, size.height / 2 - scaledHeight);
        pg.addPoint(size.width - scaledDist, size.height / 2 - scaledHeight);
        pg.addPoint(size.width / 2, size.height / 2 + scaledHeight);
        g.fillPolygon(pg);
    }

    public void setLinkedButton(AbstractButton actionButton) {
        if (this.linkedButton != null) {
            this.linkedButton.removeMouseListener(this.hoverHandler);
            this.linkedButton.removeKeyListener(this.actionKeyHandler);
        }
        this.linkedButton = actionButton;
        if (this.linkedButton != null) {
            this.linkedButton.addMouseListener(this.hoverHandler);
            this.linkedButton.addKeyListener(this.actionKeyHandler);
        }
    }

    protected void processActionEvent() {
        ActionListener listener = this.actionListener;
        if (listener != null) {
            listener.actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }

    public PopupMenuListener getPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ComboButton.this.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
    }

    class ActionKeyHandler
    extends KeyAdapter {
        ActionKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 40) {
                ComboButton.this.setSelected(true);
                ComboButton.this.processActionEvent();
                e.consume();
            }
        }
    }

    class HoverHandler
    extends MouseAdapter {
        private boolean forwarding;

        HoverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.forwardEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.forwardEvent(e);
        }

        private void forwardEvent(MouseEvent e) {
            if (this.forwarding) {
                return;
            }
            this.forwarding = true;
            try {
                if (e.getSource() == ComboButton.this) {
                    if (ComboButton.this.linkedButton != null) {
                        ComboButton.this.linkedButton.dispatchEvent(this.convertEvent(e, ComboButton.this.linkedButton));
                    }
                } else {
                    ComboButton.this.processMouseEvent(this.convertEvent(e, ComboButton.this));
                }
            }
            finally {
                this.forwarding = false;
            }
        }

        private MouseEvent convertEvent(MouseEvent e, Component destination) {
            return SwingUtilities.convertMouseEvent((Component)e.getSource(), e, destination);
        }
    }
}

