/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent;

import java.awt.Dimension;
import javax.swing.ImageIcon;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.SmallTabButton;

public class SmallToolTipInfoButton {
    private final SmallTabButton _btnShowToolTip;
    private String _infoText;
    private int _displayTimeMillis;

    public SmallToolTipInfoButton(String infoText) {
        this(infoText, 5000);
    }

    public SmallToolTipInfoButton(String infoText, int displayTimeMillis) {
        this._infoText = infoText;
        this._displayTimeMillis = displayTimeMillis;
        ImageIcon smallInfoIcon = this.getSmallInfoIcon();
        this._btnShowToolTip = new SmallTabButton<boolean>(null, smallInfoIcon, false);
        Dimension size = new Dimension(smallInfoIcon.getIconWidth(), smallInfoIcon.getIconWidth());
        this._btnShowToolTip.setPreferredSize(size);
        this._btnShowToolTip.setMinimumSize(size);
        this._btnShowToolTip.setMaximumSize(size);
        GUIUtils.showExtraToolTipOnClick(this._btnShowToolTip, true, this._infoText, this._displayTimeMillis);
    }

    public SmallTabButton getButton() {
        return this._btnShowToolTip;
    }

    private ImageIcon getSmallInfoIcon() {
        return Main.getApplication().getResources().getIcon("small_info");
    }

    public void setInfoText(String infoText) {
        this._infoText = infoText;
    }

    public void setEnabled(boolean b) {
        this._btnShowToolTip.setEnabled(b);
    }
}

