/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.filechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileManagementUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class ChooserPreviewer
extends JComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ChooserPreviewer.class);
    private static final ILogger s_log = LoggerController.createLogger(ChooserPreviewer.class);
    private final JPanel _emptyPnl = new JPanel();
    private final JTextArea _textComponent = new JTextArea();
    private final JLabel _imageComponent = new JLabel();
    private Component _currentComponent;
    private JScrollPane _currentComponentSp;
    private JFileChooser _fileChooser;
    private PropertyChangeListener _propChangeListener;

    public ChooserPreviewer(JFileChooser fileChooser) {
        this._fileChooser = fileChooser;
        this.createUserInterface();
        this._propChangeListener = e -> this.onPropertyChanged(e);
        this._fileChooser.addPropertyChangeListener(this._propChangeListener);
    }

    void cleanup() {
        this._fileChooser.removePropertyChangeListener(this._propChangeListener);
    }

    private void fileChanged() {
        Component componentToUse = this._emptyPnl;
        File file = this._fileChooser.getSelectedFile();
        if (file != null && file.isFile() && file.canRead()) {
            String suffix = Utilities.getFileNameSuffix(file.getPath()).toLowerCase();
            componentToUse = suffix.equals("gif") || suffix.equals("jpg") || suffix.equals("jpeg") || suffix.equals("png") ? this.readImageFile(file) : this.readTextFile(file);
        }
        if (componentToUse != this._currentComponent) {
            this._currentComponentSp.setViewportView(componentToUse);
            this._currentComponent = componentToUse;
        }
    }

    protected Component readImageFile(File file) {
        ImageIcon icon = new ImageIcon(file.getPath());
        this._imageComponent.setIcon(icon);
        return this._imageComponent;
    }

    protected Component readTextFile(File file) {
        String text = "";
        if (file != null && file.isFile() && file.canRead()) {
            try {
                text = FileManagementUtil.readFileAsString(file, 15000);
            }
            catch (Exception e) {
                String errMsg = s_stringMgr.getString("ChooserPreviewer.errorReadingFile", file.getAbsolutePath(), e.toString());
                Main.getApplication().getMessageHandler().showErrorMessage(errMsg);
                text = errMsg;
                s_log.error(errMsg, e);
            }
        }
        this._textComponent.setText(text);
        this._textComponent.setCaretPosition(0);
        return this._textComponent;
    }

    private void createUserInterface() {
        this._textComponent.setEditable(false);
        this.setLayout(new BorderLayout());
        this._currentComponentSp = new JScrollPane(this._textComponent);
        this.add((Component)this._currentComponentSp, "Center");
    }

    private void onPropertyChanged(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SelectedFileChangedProperty")) {
            this.fileChanged();
        }
    }
}

