/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.filechooser;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JSplitPane;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.filechooser.ChooserPreviewer;
import net.sourceforge.squirrel_sql.fw.props.Props;

public class PreviewFileChooser
extends JDialog {
    private static final String PREF_KEY_SPLIT_DIVIDER_LOCATION = "Squirrel.PreviewFileChooser.split.divider.location";
    private static int _option = -1;

    public PreviewFileChooser(Window owner, String title) {
        super(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
    }

    public static int showOpenDialog(Component parent, JFileChooser fileChooser) {
        PreviewFileChooser previewFileChooser = new PreviewFileChooser(GUIUtils.getOwningWindow(parent), fileChooser.getDialogTitle());
        previewFileChooser.getContentPane().setLayout(new GridLayout(1, 1));
        JSplitPane splitPane = new JSplitPane();
        previewFileChooser.getContentPane().add(splitPane);
        ActionListener fileChooserButtonActionListener = e -> PreviewFileChooser.onFileChooserButtonClicked(previewFileChooser, fileChooser, e.getActionCommand());
        fileChooser.addActionListener(fileChooserButtonActionListener);
        splitPane.setLeftComponent(fileChooser);
        ChooserPreviewer chooserPreviewer = new ChooserPreviewer(fileChooser);
        splitPane.setRightComponent(chooserPreviewer);
        Dimension size = GUIUtils.initLocation(previewFileChooser, 800, 500);
        GUIUtils.enableCloseByEscape(previewFileChooser);
        PreviewFileChooser.initSplitDividerLocation(splitPane, size);
        previewFileChooser.setVisible(true);
        chooserPreviewer.cleanup();
        Props.putInt(PREF_KEY_SPLIT_DIVIDER_LOCATION, splitPane.getDividerLocation());
        fileChooser.removeActionListener(fileChooserButtonActionListener);
        previewFileChooser.dispose();
        return _option;
    }

    private static void onFileChooserButtonClicked(PreviewFileChooser previewFileChooser, JFileChooser fileChooser, String actionCommand) {
        if ("ApproveSelection".equals(actionCommand)) {
            _option = 0;
        } else if ("CancelSelection".equals(actionCommand)) {
            _option = 1;
        }
        previewFileChooser.setVisible(false);
    }

    private static void initSplitDividerLocation(JSplitPane splitPane, Dimension size) {
        int preferredDividerLocation;
        int dividerLocation = preferredDividerLocation = Props.getInt(PREF_KEY_SPLIT_DIVIDER_LOCATION, size.width / 2);
        if (0 < splitPane.getWidth()) {
            dividerLocation = Math.min(splitPane.getMaximumDividerLocation(), preferredDividerLocation);
        }
        splitPane.setDividerLocation(dividerLocation);
    }
}

