/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.statusbar;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.LogPanel;
import net.sourceforge.squirrel_sql.client.gui.MemoryPanel;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.TimePanel;
import net.sourceforge.squirrel_sql.fw.gui.statusbar.StatusBarUtil;

public class MainFrameStatusBar
extends JPanel {
    private Font _font;
    private final GridBagConstraints _gbc = new GridBagConstraints();
    private JTextField _textLbl = new JTextField();

    public MainFrameStatusBar(IApplication app) {
        super(new GridBagLayout());
        this.createGUI(app);
    }

    private void createGUI(IApplication app) {
        this._gbc.anchor = 17;
        this._gbc.weightx = 1.0;
        this._gbc.fill = 2;
        this._gbc.gridy = 0;
        this._gbc.gridx = 0;
        this._textLbl.setEditable(false);
        GUIUtils.inheritBackground(this._textLbl);
        this.addJComponent(this._textLbl);
        this._gbc.weightx = 0.0;
        this._gbc.anchor = 10;
        this._gbc.gridx = -1;
        this._gbc.insets.left = 2;
        this.addJComponent(new LogPanel(app));
        this.addJComponent(new MemoryPanel(app));
        this.addJComponent(new TimePanel());
    }

    public void addJComponent(JComponent comp) {
        comp.setBorder(StatusBarUtil.createComponentBorder());
        if (this._font != null) {
            comp.setFont(this._font);
            StatusBarUtil.updateSubcomponentsFont(comp, this._font);
        }
        GUIUtils.inheritBackground(comp);
        super.add((Component)comp, this._gbc);
    }

    public void setText(String text) {
        this._textLbl.setText(text);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._font = font;
        StatusBarUtil.updateSubcomponentsFont(this, this._font);
    }
}

