/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.statusbar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.statusbar.StatusBarHrefListener;
import net.sourceforge.squirrel_sql.fw.gui.statusbar.StatusBarUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class SessionStatusBar
extends JPanel {
    private static final Color TRANSPARENT = new Color(0xFFFFFF, true);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionStatusBar.class);
    private final JEditorPane _textLbl;
    private final JProgressBar _progressBar = new JProgressBar();
    private final JPanel _pnlLabelOrProgress = new JPanel(new BorderLayout());
    private final GridBagConstraints _gbc = new GridBagConstraints();
    private Font _font;
    private StatusBarHrefListener _statusBarHrefListener;
    private Object _hrefReferenceObject;
    private JMenuItem _additionalRightMouseMenuItem;

    public SessionStatusBar() {
        super(new GridBagLayout());
        this._textLbl = new JEditorPane();
        this._textLbl.setEditable(false);
        this._textLbl.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this._textLbl.setBackground(TRANSPARENT);
        this._textLbl.setOpaque(false);
        this._textLbl.addHyperlinkListener(e -> this.onTextLblHyperEvent(e));
        this._textLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SessionStatusBar.this.onTriggerTextLblRightMouseMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SessionStatusBar.this.onTriggerTextLblRightMouseMenu(e);
            }
        });
        this.createGUI();
    }

    private void onTriggerTextLblRightMouseMenu(MouseEvent me) {
        if (!me.isPopupTrigger()) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mnuCopyAll = new JMenuItem(s_stringMgr.getString("StatusBar.rightMouseMenu.copyAll"));
        mnuCopyAll.addActionListener(e -> ClipboardUtil.copyToClip(this.getTextWithoutHtmlTags(this._textLbl), true));
        popupMenu.add(mnuCopyAll);
        if (!StringUtilities.isEmpty(this._textLbl.getSelectedText(), true)) {
            JMenuItem mnuCopySelected = new JMenuItem(s_stringMgr.getString("StatusBar.rightMouseMenu.copySelection"));
            mnuCopySelected.addActionListener(e -> ClipboardUtil.copyToClip(this._textLbl.getSelectedText(), true));
            popupMenu.add(mnuCopySelected);
        }
        if (null != this._additionalRightMouseMenuItem) {
            popupMenu.add(this._additionalRightMouseMenuItem);
        }
        popupMenu.show(this._textLbl, me.getX(), me.getY());
    }

    private String getTextWithoutHtmlTags(JEditorPane textLbl) {
        try {
            return textLbl.getDocument().getText(0, textLbl.getDocument().getLength());
        }
        catch (BadLocationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private void onTextLblHyperEvent(HyperlinkEvent e) {
        if (null != this._statusBarHrefListener && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this._statusBarHrefListener.hrefClicked(e.getDescription(), this._hrefReferenceObject);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._font = font;
        StatusBarUtil.updateSubcomponentsFont(this, this._font);
    }

    public void setText(String text, Object hrefReferenceObject) {
        this._hrefReferenceObject = hrefReferenceObject;
        String myText = null;
        if (text != null) {
            myText = text.trim();
        }
        if (myText != null && myText.length() > 0) {
            if (myText.toLowerCase().startsWith("<html>")) {
                this._textLbl.setContentType("text/html");
            } else {
                this._textLbl.setContentType("text/plain");
            }
            this._textLbl.setText(myText);
        } else {
            this.clearText();
        }
    }

    public void clearText() {
        this._hrefReferenceObject = null;
        this._textLbl.setContentType("text/plain");
        this._textLbl.setText("");
    }

    public void addJComponent(JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException("JComponent == null");
        }
        comp.setBorder(StatusBarUtil.createComponentBorder());
        if (this._font != null) {
            comp.setFont(this._font);
            StatusBarUtil.updateSubcomponentsFont(comp, this._font);
        }
        GUIUtils.inheritBackground(comp);
        super.add((Component)comp, this._gbc);
    }

    private void createGUI() {
        this.clearText();
        this._progressBar.setStringPainted(true);
        this._pnlLabelOrProgress.add((Component)this._textLbl, "Center");
        this._gbc.anchor = 17;
        this._gbc.weightx = 1.0;
        this._gbc.fill = 1;
        this._gbc.gridy = 0;
        this._gbc.gridx = 0;
        this.addJComponent(this._pnlLabelOrProgress);
        this._gbc.weightx = 0.0;
        this._gbc.anchor = 17;
        this._gbc.gridx = -1;
        this._gbc.insets.left = 2;
    }

    public void setStatusBarProgress(String msg, int minimum, int maximum, int value, ActionListener stopAction) {
        if (!(this._pnlLabelOrProgress.getComponent(0) instanceof JProgressBar)) {
            this._pnlLabelOrProgress.removeAll();
            this._pnlLabelOrProgress.add((Component)this._progressBar, "Center");
            if (null != stopAction) {
                JButton stopButton = new JButton(Main.getApplication().getResources().getIcon("stop"));
                stopButton.addActionListener(stopAction);
                this._pnlLabelOrProgress.add((Component)GUIUtils.styleAsToolbarButton(stopButton), "East");
            }
            this.invalidate();
        }
        this._progressBar.setMinimum(minimum);
        this._progressBar.setMaximum(maximum);
        this._progressBar.setValue(value);
        if (null != msg) {
            this._progressBar.setString(msg);
        } else {
            this._progressBar.setString("");
        }
    }

    public void setStatusBarProgressFinished() {
        if (this._pnlLabelOrProgress.getComponent(0) instanceof JProgressBar) {
            this._pnlLabelOrProgress.removeAll();
            this._pnlLabelOrProgress.add((Component)this._textLbl, "Center");
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this._pnlLabelOrProgress != null) {
            this._pnlLabelOrProgress.setBackground(bg);
        }
        if (this._progressBar != null) {
            this._progressBar.setBackground(bg);
        }
    }

    public void setHrefListener(StatusBarHrefListener statusBarHrefListener) {
        this._statusBarHrefListener = statusBarHrefListener;
    }

    public void setAdditionalRightMouseMenuItem(JMenuItem additionalRightMouseMenuItem) {
        this._additionalRightMouseMenuItem = additionalRightMouseMenuItem;
    }

    public Object getHrefReferenceObject() {
        return this._hrefReferenceObject;
    }
}

