/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.stdtextpopup;

import java.awt.event.ActionEvent;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.session.SQLEntryPanelUtil;

public class TextActionUtil {
    public static void wrapCopyActionToSelectLineOnEmptySelection(JTextComponent textComponent, ActionEvent evt, Runnable copyActionPerformedCall) {
        if (textComponent == null) {
            return;
        }
        Integer previousCaretPos = null;
        if (null == textComponent.getSelectedText()) {
            previousCaretPos = textComponent.getCaretPosition();
            TextActionUtil.selectLineAtCursor(textComponent);
        }
        copyActionPerformedCall.run();
        if (null != previousCaretPos) {
            textComponent.setCaretPosition(previousCaretPos);
        }
    }

    public static void wrapCutActionToSelectLineOnEmptySelection(JTextComponent textComponent, ActionEvent evt, Runnable cutActionPerformedCall) {
        if (textComponent == null) {
            return;
        }
        if (null == textComponent.getSelectedText()) {
            TextActionUtil.selectLineAtCursor(textComponent);
        }
        cutActionPerformedCall.run();
    }

    private static void selectLineAtCursor(JTextComponent textComponent) {
        int[] lineBounds = SQLEntryPanelUtil.getLineBoundsAtCursor(textComponent);
        if (lineBounds[0] < lineBounds[1]) {
            textComponent.setSelectionStart(lineBounds[0]);
            textComponent.setSelectionEnd(lineBounds[1]);
        }
    }
}

