/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.table;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.SquirrelTableCellRenderer;
import net.sourceforge.squirrel_sql.fw.gui.ColumnOrder;
import net.sourceforge.squirrel_sql.fw.gui.table.ButtonTableHeaderDraggedColumnListener;
import net.sourceforge.squirrel_sql.fw.gui.table.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.gui.table.SortingListener;
import net.sourceforge.squirrel_sql.fw.gui.table.TableAccessForHeader;
import net.sourceforge.squirrel_sql.fw.gui.table.TableHeaderButtonRenderer;
import net.sourceforge.squirrel_sql.fw.gui.table.TableHeaderMouseState;
import net.sourceforge.squirrel_sql.fw.gui.table.TableSortingAdmin;
import net.sourceforge.squirrel_sql.fw.gui.table.TableSortingItem;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ButtonTableHeader
extends JTableHeader {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ButtonTableHeader.class);
    private static final String PREF_KEY_ALWAYS_ADJUST_ALL_COLUMN_HEADERS = "Squirrel.alwaysAdoptAllColumnHeaders";
    private TableModelListener _dataListener;
    private SortingListener _sortingListener;
    private TableHeaderMouseState _mouseState = new TableHeaderMouseState();
    private TableAccessForHeader _tableAccess = () -> this.getTable();
    private ButtonTableHeaderDraggedColumnListener _buttonTableHeaderDraggedColumnListener;

    public ButtonTableHeader() {
        this.setDefaultRenderer(new TableHeaderButtonRenderer(this.getFont(), this._mouseState, this._tableAccess));
        HeaderListener hl = new HeaderListener();
        this.addMouseListener(hl);
        this.addMouseMotionListener(hl);
        this._sortingListener = tableSortingAdmin -> this.onSortingDone(tableSortingAdmin);
        this._dataListener = e -> this._tableAccess.getTableSortingAdmin().clear();
    }

    private void onSortingDone(TableSortingAdmin tableSortingAdmin) {
        if (null != tableSortingAdmin.getLastChangedSortingItem()) {
            this._mouseState.setPressedViewColumnIdx(this.getViewColumnIndex(tableSortingAdmin.getLastChangedSortingItem().getSortedModelColumn()));
        }
        this.repaint();
    }

    public int getViewColumnIndex(int modelColumnIx) {
        for (int i = 0; i < this.getTable().getColumnModel().getColumnCount(); ++i) {
            if (modelColumnIx != this.getTable().getColumnModel().getColumn(i).getModelIndex()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setTable(JTable table) {
        SortableTableModel sortableTableModel;
        TableModel obj;
        JTable oldTable = this.getTable();
        if (oldTable != null && (obj = oldTable.getModel()) instanceof SortableTableModel) {
            sortableTableModel = (SortableTableModel)obj;
            sortableTableModel.getActualModel().removeTableModelListener(this._dataListener);
            sortableTableModel.removeSortingListener(this._sortingListener);
        }
        super.setTable(table);
        if (table != null && (obj = table.getModel()) instanceof SortableTableModel) {
            sortableTableModel = (SortableTableModel)obj;
            sortableTableModel.getActualModel().addTableModelListener(this._dataListener);
            sortableTableModel.addSortingListener(this._sortingListener);
        }
        this._tableAccess.getTableSortingAdmin().clear();
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int col = this.columnAtPoint(e.getPoint());
        String retStr = null;
        if (col >= 0) {
            TableColumn tcol = this.getColumnModel().getColumn(col);
            int colWidth = tcol.getWidth();
            TableCellRenderer h = tcol.getHeaderRenderer();
            if (h == null) {
                h = this.getDefaultRenderer();
            }
            Component c = h.getTableCellRendererComponent(this.table, tcol.getHeaderValue(), false, false, -1, col);
            int prefWidth = c.getPreferredSize().width;
            if (prefWidth > colWidth) {
                retStr = tcol.getHeaderValue().toString();
            }
        }
        return retStr;
    }

    public void adjustAllColWidths(boolean includeColHeaders) {
        for (int i = 0; i < this.getTable().getColumnModel().getColumnCount(); ++i) {
            this.adjustColWidth(i, includeColHeaders);
        }
    }

    public static boolean isAlwaysAdjustAllColWidths() {
        return Props.getBoolean(PREF_KEY_ALWAYS_ADJUST_ALL_COLUMN_HEADERS, false);
    }

    public static void setAlwaysAdjustAllColWidths(boolean b) {
        Props.putBoolean(PREF_KEY_ALWAYS_ADJUST_ALL_COLUMN_HEADERS, b);
    }

    public void initColWidths() {
        if (ButtonTableHeader.isAlwaysAdjustAllColWidths()) {
            SwingUtilities.invokeLater(() -> this.adjustAllColWidths(true));
        }
    }

    private void adjustColWidth(int colIx, boolean includeColHeaders) {
        int modelIx = this.getTable().convertColumnIndexToModel(colIx);
        int rowCount = this.getTable().getModel().getRowCount();
        int newWidth = 20;
        if (includeColHeaders) {
            TableColumn column = this.getTable().getColumnModel().getColumn(colIx);
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            if (null == headerRenderer) {
                headerRenderer = this.getTable().getTableHeader().getDefaultRenderer();
            }
            Component headerComp = headerRenderer.getTableCellRendererComponent(this.getTable(), null, false, false, 0, colIx);
            FontMetrics headerFontMetrics = headerComp.getFontMetrics(headerComp.getFont());
            Rectangle2D bounds = headerFontMetrics.getStringBounds("" + column.getHeaderValue(), headerComp.getGraphics());
            int width = bounds.getBounds().width;
            TableSortingItem tableSortingItem = this._tableAccess.getTableSortingAdmin().getTableSortingItem(this.getTable().convertColumnIndexToModel(colIx));
            if (null != tableSortingItem && null != tableSortingItem.getSortedColumnIcon()) {
                width += tableSortingItem.getSortedColumnIcon().getIconWidth();
            }
            newWidth = Math.max(newWidth, width);
        }
        if (0 == rowCount) {
            if (includeColHeaders) {
                this.getColumnModel().getColumn(colIx).setPreferredWidth(newWidth + 10);
            }
            return;
        }
        TableCellRenderer cellRenderer = this.getTable().getCellRenderer(0, colIx);
        Component cellComp = cellRenderer.getTableCellRendererComponent(this.getTable(), null, false, false, rowCount - 1, colIx);
        FontMetrics cellFontMetrics = cellComp.getFontMetrics(cellComp.getFont());
        int maxColumnAdjustLength = Integer.MAX_VALUE;
        if (Main.getApplication().getSquirrelPreferences().getMaxColumnAdjustLengthDefined()) {
            maxColumnAdjustLength = Main.getApplication().getSquirrelPreferences().getMaxColumnAdjustLength();
        }
        for (int i = 0; i < rowCount; ++i) {
            Object value = this.getTable().getModel().getValueAt(i, modelIx);
            Object stringVal = "";
            stringVal = this.getTable().getCellRenderer(i, colIx) instanceof SquirrelTableCellRenderer ? (String)stringVal + ((SquirrelTableCellRenderer)((Object)this.getTable().getCellRenderer(i, colIx))).renderValue(value) : (String)stringVal + value;
            if (maxColumnAdjustLength < ((String)stringVal).length()) {
                stringVal = ((String)stringVal).substring(0, maxColumnAdjustLength);
            }
            Rectangle2D bounds = cellFontMetrics.getStringBounds((String)stringVal, cellComp.getGraphics());
            newWidth = Math.max(newWidth, bounds.getBounds().width);
        }
        this.getColumnModel().getColumn(colIx).setPreferredWidth(newWidth + 10);
    }

    public void setDraggedColumnListener(ButtonTableHeaderDraggedColumnListener buttonTableHeaderDraggedColumnListener) {
        this._buttonTableHeaderDraggedColumnListener = buttonTableHeaderDraggedColumnListener;
    }

    class HeaderListener
    extends MouseAdapter
    implements MouseMotionListener {
        HeaderListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ButtonTableHeader.this.getCursor().getType() == 11 || 1 != e.getButton()) {
                return;
            }
            ButtonTableHeader.this._mouseState.setPressed(true);
            if (-42 == ButtonTableHeader.this.table.convertColumnIndexToModel(ButtonTableHeader.this.columnAtPoint(e.getPoint()))) {
                return;
            }
            ButtonTableHeader.this._mouseState.setPressedViewColumnIdx(ButtonTableHeader.this.columnAtPoint(e.getPoint()));
            ButtonTableHeader.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (2 == e.getClickCount() && ButtonTableHeader.this.getCursor().getType() == 11) {
                int colIx = ButtonTableHeader.this.columnAtPoint(e.getPoint());
                Rectangle headerRect = ButtonTableHeader.this.getHeaderRect(colIx);
                int distToColBegin = e.getPoint().x - headerRect.x;
                int distToColEnd = headerRect.x + headerRect.width - e.getPoint().x;
                if (distToColBegin < distToColEnd && 0 < colIx && colIx < ButtonTableHeader.this.getColumnModel().getColumnCount()) {
                    --colIx;
                }
                ButtonTableHeader.this.adjustColWidth(colIx, true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (ButtonTableHeader.this.getCursor().getType() == 11 || 1 != e.getButton()) {
                return;
            }
            if (-42 == ButtonTableHeader.this.table.convertColumnIndexToModel(ButtonTableHeader.this.columnAtPoint(e.getPoint()))) {
                ButtonTableHeader.this._mouseState.setPressed(false);
                ButtonTableHeader.this._mouseState.setDragged(false);
                return;
            }
            ButtonTableHeader.this._mouseState.setPressed(false);
            if (!ButtonTableHeader.this._mouseState.isDragged()) {
                int newSortColumn = ButtonTableHeader.this.getTable().convertColumnIndexToModel(ButtonTableHeader.this._mouseState.getPressedViewColumnIdx());
                TableModel tm = ButtonTableHeader.this.table.getModel();
                if (newSortColumn > -1 && newSortColumn < tm.getColumnCount() && tm instanceof SortableTableModel) {
                    TableSortingItem tableSortingItem = ButtonTableHeader.this._tableAccess.getTableSortingAdmin().getTableSortingItem(newSortColumn);
                    ColumnOrder newOrder = ColumnOrder.ASC;
                    if (null != tableSortingItem) {
                        newOrder = tableSortingItem.getColumnOrder().next();
                    }
                    ButtonTableHeader.this._tableAccess.getTableSortingAdmin().updateSortedColumn(newSortColumn, newOrder, 0 == (e.getModifiersEx() & 0x80));
                    this.writeMultipleSortingToMessagePanel();
                    ((SortableTableModel)tm).sortTableBySortingAdmin();
                } else {
                    ButtonTableHeader.this._tableAccess.getTableSortingAdmin().clear();
                }
                ButtonTableHeader.this.repaint();
            } else if (null != ButtonTableHeader.this._buttonTableHeaderDraggedColumnListener) {
                ButtonTableHeader.this._buttonTableHeaderDraggedColumnListener.columnDragged();
            }
            ButtonTableHeader.this._mouseState.setDragged(false);
        }

        public void writeMultipleSortingToMessagePanel() {
            if (1 < ButtonTableHeader.this._tableAccess.getTableSortingAdmin().getTableSortingItems().size()) {
                String msg = s_stringMgr.getString("TableSortingAdmin.multipleSortingMessagePrefix") + " ";
                for (int i = 0; i < ButtonTableHeader.this._tableAccess.getTableSortingAdmin().getTableSortingItems().size(); ++i) {
                    TableSortingItem tableSortingItem = ButtonTableHeader.this._tableAccess.getTableSortingAdmin().getTableSortingItems().get(i);
                    msg = msg + ButtonTableHeader.this.getColumnModel().getColumn(tableSortingItem.getSortedModelColumn()).getHeaderValue() + " " + tableSortingItem.getColumnOrder().name();
                    if (i + 1 >= ButtonTableHeader.this._tableAccess.getTableSortingAdmin().getTableSortingItems().size()) continue;
                    msg = msg + ", ";
                }
                Main.getApplication().getMessageHandler().showMessage(msg);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ButtonTableHeader.this._mouseState.setDragged(true);
            if (ButtonTableHeader.this._mouseState.isPressed()) {
                ButtonTableHeader.this._mouseState.setPressed(false);
                ButtonTableHeader.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ButtonTableHeader.this._mouseState.setDragged(false);
        }
    }
}

