/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.squirrel_sql.fw.gui.table.TableAccessForHeader;
import net.sourceforge.squirrel_sql.fw.gui.table.TableHeaderMouseState;
import net.sourceforge.squirrel_sql.fw.gui.table.TableSortingItem;

class TableHeaderButtonRenderer
implements TableCellRenderer {
    private final TableHeaderMouseState _mouseState;
    private final TableAccessForHeader _tableAccess;
    private JButton _buttonRaised;
    private JButton _buttonLowered;

    TableHeaderButtonRenderer(Font font, TableHeaderMouseState mouseState, TableAccessForHeader tableAccess) {
        this._mouseState = mouseState;
        this._tableAccess = tableAccess;
        this._buttonRaised = new JButton();
        this._buttonRaised.putClientProperty("JButton.buttonType", "gradient");
        this._buttonRaised.setMargin(new Insets(0, 0, 0, 0));
        this._buttonRaised.setFont(font);
        this._buttonLowered = new JButton();
        this._buttonLowered.putClientProperty("JButton.buttonType", "gradient");
        this._buttonLowered.setMargin(new Insets(0, 0, 0, 0));
        this._buttonLowered.setFont(font);
        this._buttonLowered.getModel().setArmed(true);
        this._buttonLowered.getModel().setPressed(true);
        this._buttonLowered.setMinimumSize(new Dimension(50, 25));
        this._buttonRaised.setMinimumSize(new Dimension(50, 25));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            value = "";
        }
        if (this._mouseState.getPressedViewColumnIdx() == column && this._mouseState.isPressed()) {
            this._buttonLowered.setText(value.toString());
            this._buttonLowered.setIcon(null);
            TableSortingItem tableSortingItem = this._tableAccess.getTableSortingAdmin().getTableSortingItem(this._tableAccess.getTable().convertColumnIndexToModel(column));
            if (null != tableSortingItem && null != tableSortingItem.getSortedColumnIcon()) {
                this._buttonLowered.setIcon(tableSortingItem.getSortedColumnIcon());
            }
            return this._buttonLowered;
        }
        this._buttonRaised.setText(value.toString());
        this._buttonRaised.setIcon(null);
        TableSortingItem tableSortingItem = this._tableAccess.getTableSortingAdmin().getTableSortingItem(this._tableAccess.getTable().convertColumnIndexToModel(column));
        if (null != tableSortingItem && null != tableSortingItem.getSortedColumnIcon()) {
            this._buttonRaised.setIcon(tableSortingItem.getSortedColumnIcon());
        }
        return this._buttonRaised;
    }
}

